/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.workflow.testing.utils;

import com.github.cafdataprocessing.workflow.testing.models.ApplicationMock;
import com.github.cafdataprocessing.workflow.testing.models.ConfigurationSourceMock;
import com.github.cafdataprocessing.workflow.testing.models.DocumentMock;
import com.github.cafdataprocessing.workflow.testing.models.FieldsMock;
import com.github.cafdataprocessing.workflow.testing.models.InputMessageProcessorMock;
import com.github.cafdataprocessing.workflow.testing.models.SubdocumentMock;
import com.github.cafdataprocessing.workflow.testing.models.TaskMock;
import com.github.cafdataprocessing.workflow.testing.models.WorkerTaskDataMock;
import com.hpe.caf.api.worker.TaskSourceInfo;
import com.hpe.caf.api.worker.TaskStatus;
import com.hpe.caf.worker.document.config.DocumentWorkerConfiguration;
import com.hpe.caf.worker.document.model.Document;
import com.hpe.caf.worker.document.model.Failures;
import com.hpe.caf.worker.document.model.Fields;
import com.hpe.caf.worker.document.model.Subdocument;
import com.hpe.caf.worker.document.model.Subdocuments;
import com.oracle.truffle.js.scriptengine.GraalJSScriptEngine;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;

public class WorkflowHelper {
    private WorkflowHelper() {
    }

    public static Invocable createInvocableJavascriptEngineWithActionsAndWorkflowControl() throws IOException, ScriptException {
        ScriptEngine graalJs = WorkflowHelper.getScriptEngine();
        graalJs.eval("var actionFamilyHashing = {name: \"family_hashing\", terminateOnFailure: false};\nvar actionBulkIndexer = {name: \"bulk_indexer\", terminateOnFailure: true};\nvar actionElastic = {name: \"elastic\", terminateOnFailure: false};\nvar ACTIONS = [actionFamilyHashing, actionBulkIndexer, actionElastic];");
        graalJs.eval(new InputStreamReader(new FileInputStream(Paths.get("src", "main", "resources", "workflow-control.js").toFile())));
        WorkflowHelper.evalAddFailuresScript(graalJs);
        return (Invocable)((Object)graalJs);
    }

    private static void evalAddFailuresScript(ScriptEngine engine) throws IOException, ScriptException {
        try (InputStreamReader reader = new InputStreamReader(new FileInputStream(Paths.get("src", "main", "resources", "add-failures.js").toFile()));){
            String addFailures = IOUtils.toString((Reader)reader);
            engine.eval("\nthisScriptObject = `\n" + addFailures + "`;\n");
        }
    }

    public static Invocable createInvocableJavascriptEngineWithActionsAndWorkflowControl(String ... scripts) throws IOException, ScriptException {
        ScriptEngine graalJs = WorkflowHelper.getScriptEngine();
        graalJs.eval("var actionFamilyHashing = {name: \"family_hashing\", terminateOnFailure: false};\nvar actionBulkIndexer = {name: \"bulk_indexer\", terminateOnFailure: true};\nvar actionElastic = {name: \"elastic\", terminateOnFailure: false};\nvar ACTIONS = [actionFamilyHashing, actionBulkIndexer, actionElastic];");
        graalJs.eval(new InputStreamReader(new FileInputStream(Paths.get("src", "main", "resources", "workflow-control.js").toFile())));
        WorkflowHelper.evalAddFailuresScript(graalJs);
        for (String script : scripts) {
            graalJs.eval(script);
        }
        return (Invocable)((Object)graalJs);
    }

    public static Invocable createInvocableJavascriptEngine(List<String> codesToEval, List<Path> filesToReadAndEval) throws IOException, ScriptException {
        ScriptEngine graalJs = WorkflowHelper.getScriptEngine();
        if (CollectionUtils.isNotEmpty(codesToEval)) {
            for (String code : codesToEval) {
                graalJs.eval(code);
            }
        }
        if (CollectionUtils.isNotEmpty(filesToReadAndEval)) {
            for (Path inputFile : filesToReadAndEval) {
                graalJs.eval(new InputStreamReader(new FileInputStream(inputFile.toFile())));
            }
        }
        return (Invocable)((Object)graalJs);
    }

    public static Document createDocument(String reference, Fields fields, Failures failures, Map<String, String> customData, Subdocuments subdocuments, Document parentDoc, Document rootDoc, boolean includeApplication, boolean inputMessageProcessor) {
        ApplicationMock application;
        TaskMock task;
        HashMap<String, String> docCustomData;
        TaskSourceInfo tsi = new TaskSourceInfo("source_name", "5");
        WorkerTaskDataMock wtd = new WorkerTaskDataMock("classifier", 2, TaskStatus.RESULT_SUCCESS, new byte[0], new byte[0], null, "to", tsi);
        DocumentWorkerConfiguration dwc = new DocumentWorkerConfiguration();
        dwc.setWorkerName("worker-base");
        dwc.setWorkerVersion("1.0.0-SNAPSHOT");
        ConfigurationSourceMock csm = new ConfigurationSourceMock(dwc);
        HashMap<String, String> hashMap = docCustomData = customData != null ? customData : new HashMap<String, String>();
        if (!includeApplication) {
            task = new TaskMock(docCustomData, rootDoc, null, wtd, null, null);
            application = null;
        } else {
            InputMessageProcessorMock inputMessageProcessorTest = new InputMessageProcessorMock(inputMessageProcessor);
            application = new ApplicationMock(inputMessageProcessorTest, csm);
            task = new TaskMock(docCustomData, rootDoc, null, wtd, null, application);
        }
        DocumentMock temp = new DocumentMock(reference, fields, task, docCustomData, failures, subdocuments, application, parentDoc, rootDoc);
        task.setDocument(temp);
        FieldsMock mockedFields = new FieldsMock(fields, null, (Document)temp);
        temp.setFields(mockedFields);
        temp.setRootDocument(temp);
        return temp;
    }

    public static Subdocument createSubdocument(String reference, Fields fields, Failures failures, Subdocuments subdocuments, Document parentDoc, Document rootDoc, boolean includeApplication, boolean inputMessageProcessor) {
        ApplicationMock application;
        TaskMock task;
        TaskSourceInfo tsi = new TaskSourceInfo("source_name", "5");
        WorkerTaskDataMock wtd = new WorkerTaskDataMock("classifier", 2, TaskStatus.RESULT_SUCCESS, new byte[0], new byte[0], null, "to", tsi);
        DocumentWorkerConfiguration dwc = new DocumentWorkerConfiguration();
        dwc.setWorkerName("worker-base");
        dwc.setWorkerVersion("1.0.0-SNAPSHOT");
        ConfigurationSourceMock csm = new ConfigurationSourceMock(dwc);
        if (!includeApplication) {
            task = new TaskMock(new HashMap<String, String>(), rootDoc, null, wtd, null, null);
            application = null;
        } else {
            InputMessageProcessorMock inputMessageProcessorTest = new InputMessageProcessorMock(inputMessageProcessor);
            application = new ApplicationMock(inputMessageProcessorTest, csm);
            task = new TaskMock(new HashMap<String, String>(), rootDoc, null, wtd, null, application);
        }
        SubdocumentMock temp = new SubdocumentMock(reference, fields, task, new HashMap<String, String>(), failures, subdocuments, application, parentDoc, rootDoc);
        task.setDocument((Document)temp);
        return temp;
    }

    private static ScriptEngine getScriptEngine() {
        return GraalJSScriptEngine.create(null, (Context.Builder)Context.newBuilder((String[])new String[]{"js"}).allowExperimentalOptions(true).allowHostAccess(HostAccess.ALL).allowHostClassLookup(s -> true).option("js.load-from-classpath", "true"));
    }
}

