/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.workflow;

import com.github.cafdataprocessing.workflow.PoisonMessageDetector;
import com.github.cafdataprocessing.workflow.model.ArgumentDefinition;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.hpe.caf.worker.document.exceptions.DocumentWorkerTransientException;
import com.hpe.caf.worker.document.model.Document;
import com.hpe.caf.worker.document.model.Field;
import com.microfocus.darwin.settings.client.ApiClient;
import com.microfocus.darwin.settings.client.ApiException;
import com.microfocus.darwin.settings.client.ResolvedSetting;
import com.microfocus.darwin.settings.client.Setting;
import com.microfocus.darwin.settings.client.SettingsApi;
import com.squareup.okhttp.CacheControl;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Response;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArgumentsManager {
    private static final Logger LOG = LoggerFactory.getLogger(ArgumentsManager.class);
    private final Gson gson = new Gson();
    private final SettingsApi settingsApi;

    public ArgumentsManager(String settingsServiceUrl) {
        this(new SettingsApi(), settingsServiceUrl);
    }

    public ArgumentsManager(SettingsApi settingsApi, String settingsServiceUrl) {
        this.settingsApi = settingsApi;
        ApiClient apiClient = new ApiClient();
        OkHttpClient client = new OkHttpClient();
        client.interceptors().add(this.getCacheControlInterceptor());
        Objects.requireNonNull(settingsServiceUrl);
        apiClient.setBasePath(settingsServiceUrl);
        settingsApi.setApiClient(apiClient);
    }

    private Interceptor getCacheControlInterceptor() {
        return chain -> {
            Response response = chain.proceed(chain.request());
            CacheControl cacheControl = new CacheControl.Builder().maxAge(5, TimeUnit.MINUTES).build();
            return response.newBuilder().header("Cache-Control", cacheControl.toString()).build();
        };
    }

    public void addArgumentsToDocument(List<ArgumentDefinition> argumentDefinitions, Document document) throws DocumentWorkerTransientException {
        if (PoisonMessageDetector.isPoisonDocument(document)) {
            return;
        }
        HashMap<String, String> arguments = new HashMap<String, String>();
        for (ArgumentDefinition argumentDefinition : argumentDefinitions) {
            String value = null;
            if (argumentDefinition.getSources() != null) {
                for (ArgumentDefinition.Source source : argumentDefinition.getSources()) {
                    switch (source.getType()) {
                        case CUSTOM_DATA: {
                            value = document.getCustomData(source.getName());
                            break;
                        }
                        case FIELD: {
                            Field field = document.getField(source.getName());
                            if (!field.hasValues()) break;
                            value = (String)field.getStringValues().get(0);
                            break;
                        }
                        case SETTINGS_SERVICE: {
                            value = this.getFromSettingService(source.getName(), source.getOptions(), document);
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException(String.format("Invalid source type [%s].", new Object[]{source.getType()}));
                        }
                    }
                    if (Strings.isNullOrEmpty((String)value)) continue;
                    break;
                }
            }
            if (Strings.isNullOrEmpty(value) && !Strings.isNullOrEmpty((String)argumentDefinition.getDefaultValue())) {
                value = argumentDefinition.getDefaultValue();
            }
            if (Strings.isNullOrEmpty(value)) continue;
            arguments.put(argumentDefinition.getName(), value);
        }
        document.getField("CAF_WORKFLOW_SETTINGS").set(this.gson.toJson(arguments));
    }

    private String getFromSettingService(String name, String options, Document document) throws DocumentWorkerTransientException {
        ResolvedSetting resolvedSetting;
        String[] scopesToProcess;
        Pattern pattern = Pattern.compile("(?<prefix>[a-zA-Z-_.]*)%(?<type>f|cd):(?<name>[a-zA-Z-_.]*)%(?<suffix>[a-zA-Z-_.]*)");
        ArrayList<String> scopes = new ArrayList<String>();
        for (String scope : scopesToProcess = options.split(",")) {
            Matcher matcher = pattern.matcher(scope);
            if (matcher.matches()) {
                String value = null;
                if (matcher.group("type").equals("f")) {
                    Field field = document.getField(matcher.group("name"));
                    if (field.hasValues()) {
                        value = (String)field.getStringValues().get(0);
                    }
                } else if (matcher.group("type").equals("cd")) {
                    value = document.getCustomData(matcher.group("name"));
                }
                if (Strings.isNullOrEmpty(value)) continue;
                scopes.add(String.format("%s%s%s", matcher.group("prefix"), value, matcher.group("suffix")));
                continue;
            }
            scopes.add(scope);
        }
        try {
            resolvedSetting = this.settingsApi.getResolvedSetting(name, String.join((CharSequence)",", scopes));
        }
        catch (ApiException e) {
            if (e.getCode() == 404) {
                LOG.warn(String.format("Setting [%s] was not found in the settings service.", name));
                return null;
            }
            throw new DocumentWorkerTransientException(e.getMessage());
        }
        if (resolvedSetting == null) {
            return null;
        }
        return resolvedSetting.getValue();
    }

    public void checkHealth() {
        block2: {
            try {
                Setting setting = this.settingsApi.getSetting("healthcheck");
            }
            catch (ApiException ex) {
                if (ex.getCode() == 404) break block2;
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
    }
}

