/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.workflow;

import com.github.cafdataprocessing.workflow.PoisonMessageDetector;
import com.google.gson.Gson;
import com.hpe.caf.worker.document.model.Document;
import com.hpe.caf.worker.document.model.Field;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FailureFieldsManager {
    private static final Logger LOG = LoggerFactory.getLogger(FailureFieldsManager.class);
    private final Gson gson = new Gson();

    public void handleExtraFailureSubFields(Document document) {
        if (!PoisonMessageDetector.isPoisonDocument(document)) {
            Field failuresField = document.getField("CAF_WORKFLOW_EXTRA_FAILURE_SUBFIELDS");
            Map<String, String> extraFailureSubfields = FailureFieldsManager.retrieveExtraFailureSubfields(document);
            failuresField.clear();
            if (!extraFailureSubfields.isEmpty()) {
                String cafWorkflowExtraFailureSubfieldsJson = this.gson.toJson(extraFailureSubfields);
                failuresField.add(cafWorkflowExtraFailureSubfieldsJson);
            }
        }
    }

    private static Map<String, String> retrieveExtraFailureSubfields(Document document) {
        String failureSubfieldKey;
        HashMap<String, String> failureSubfields = new HashMap<String, String>();
        int failureSubfieldCount = 0;
        while ((failureSubfieldKey = document.getCustomData("extraFailuresSubfieldKey" + failureSubfieldCount)) != null) {
            String failureSubfieldValue = document.getCustomData("extraFailuresSubfieldValue" + failureSubfieldCount);
            if (failureSubfieldValue == null) {
                LOG.warn("Unable to add failure subfield {} to extra failure subfields as it has no value.", (Object)failureSubfieldKey);
                continue;
            }
            failureSubfields.put(failureSubfieldKey, failureSubfieldValue);
            ++failureSubfieldCount;
        }
        return failureSubfields;
    }
}

