/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.workflow;

import com.github.cafdataprocessing.workflow.ActionTypeAdapter;
import com.github.cafdataprocessing.workflow.model.Action;
import com.github.cafdataprocessing.workflow.model.Workflow;
import com.google.common.base.Strings;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.hpe.caf.api.ConfigurationException;
import com.hpe.caf.api.worker.DataStore;
import com.hpe.caf.api.worker.DataStoreException;
import com.hpe.caf.worker.document.model.Application;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class WorkflowManager {
    private static final Logger LOG = LoggerFactory.getLogger(WorkflowManager.class);
    private final Map<String, Workflow> workflows;
    private final DataStore dataStore;

    public WorkflowManager(Application application, String workflowDirectory, String contextScriptFilePath) throws ConfigurationException {
        this.dataStore = (DataStore)application.getService(DataStore.class);
        this.workflows = this.getWorkflows(workflowDirectory, contextScriptFilePath);
    }

    public Workflow get(String workflowName) {
        return this.workflows.get(workflowName);
    }

    private static File getContextScriptFile(String contextScriptFilePath) {
        return contextScriptFilePath != null ? new File(contextScriptFilePath) : null;
    }

    private Map<String, Workflow> getWorkflows(String workflowsDirectory, String contextScriptFilePath) throws ConfigurationException {
        HashMap<String, Workflow> workflowMap = new HashMap<String, Workflow>();
        Yaml yaml = new Yaml();
        Gson gson = new GsonBuilder().registerTypeAdapter(Action.class, (Object)new ActionTypeAdapter()).setPrettyPrinting().create();
        File dir = new File(workflowsDirectory);
        if (Strings.isNullOrEmpty((String)dir.toString())) {
            throw new ConfigurationException(String.format("No workflows found in [%s].", workflowsDirectory));
        }
        File contextScriptFile = WorkflowManager.getContextScriptFile(contextScriptFilePath);
        FilenameFilter filter = (dir1, name) -> name.endsWith(".yaml");
        for (File workflowFile : dir.listFiles(filter)) {
            if (!workflowFile.exists()) {
                throw new RuntimeException(String.format("File [%s] does not exist.", workflowFile.toPath().toAbsolutePath()));
            }
            try (FileInputStream fis = new FileInputStream(workflowFile);){
                String contextScriptFileContent;
                Workflow workflow = (Workflow)yaml.loadAs((InputStream)fis, Workflow.class);
                WorkflowManager.validateWorkflow(workflow);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(String.format("var ACTIONS = %s;\n", gson.toJson(workflow.getActions())));
                if (contextScriptFile != null) {
                    if (contextScriptFile.exists()) {
                        contextScriptFileContent = FileUtils.readFileToString((File)contextScriptFile, (Charset)StandardCharsets.UTF_8);
                        stringBuilder.append(contextScriptFileContent);
                    } else {
                        LOG.warn("The context script file from the path {} does not exist.", (Object)contextScriptFilePath);
                        contextScriptFileContent = null;
                    }
                } else {
                    contextScriptFileContent = null;
                }
                try {
                    stringBuilder.append(Resources.toString((URL)Resources.getResource((String)"workflow-control.js"), (Charset)StandardCharsets.UTF_8));
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not obtain workflow-control.js");
                }
                try {
                    String addFailures = Resources.toString((URL)Resources.getResource((String)"add-failures.js"), (Charset)StandardCharsets.UTF_8).replaceAll("`", "\\`");
                    stringBuilder.append("thisScriptObject = String.raw`\n").append(addFailures);
                    if (contextScriptFileContent != null) {
                        stringBuilder.append(contextScriptFileContent);
                    }
                    stringBuilder.append("\n`;");
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not obtain add add-failures.js");
                }
                workflow.setWorkflowScript(stringBuilder.toString());
                workflow.setStorageReference(this.dataStore.store(workflow.getWorkflowScript().getBytes(StandardCharsets.UTF_8), "workflow-scripts"));
                String entryname = workflowFile.getName().replaceAll(".yaml$", "");
                workflowMap.put(entryname, workflow);
            }
            catch (IOException ex) {
                throw new ConfigurationException(String.format("Could not access workflow [%s] in configured directory.", workflowFile.toPath().toAbsolutePath(), ex));
            }
            catch (DataStoreException ex) {
                throw new ConfigurationException("Could not store workflow in configured datastore.", (Throwable)ex);
            }
        }
        if (workflowMap.isEmpty()) {
            throw new ConfigurationException("No workflows available.");
        }
        return workflowMap;
    }

    private static void validateWorkflow(Workflow workflow) throws ConfigurationException {
        ArrayList<String> actionNames = new ArrayList<String>();
        for (int index = 0; index < workflow.getActions().size(); ++index) {
            Action action = workflow.getActions().get(index);
            if (Strings.isNullOrEmpty((String)action.getName())) {
                throw new ConfigurationException(String.format("Action name is not defined for action [%s].", index));
            }
            if (actionNames.contains(action.getName())) {
                throw new ConfigurationException(String.format("Duplicated action name [%s].", action.getName()));
            }
            actionNames.add(action.getName());
        }
    }
}

