/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.workflow;

import com.github.cafdataprocessing.workflow.ArgumentsManager;
import com.github.cafdataprocessing.workflow.FailureFieldsManager;
import com.github.cafdataprocessing.workflow.ScriptManager;
import com.github.cafdataprocessing.workflow.WorkflowManager;
import com.github.cafdataprocessing.workflow.WorkflowWorkerConfiguration;
import com.github.cafdataprocessing.workflow.model.Workflow;
import com.google.common.base.Strings;
import com.hpe.caf.api.ConfigurationException;
import com.hpe.caf.worker.document.exceptions.DocumentWorkerTransientException;
import com.hpe.caf.worker.document.extensibility.DocumentWorker;
import com.hpe.caf.worker.document.model.Document;
import com.hpe.caf.worker.document.model.Field;
import com.hpe.caf.worker.document.model.HealthMonitor;
import com.hpe.caf.worker.document.model.ResponseCustomData;
import com.hpe.caf.worker.document.model.Task;
import java.util.UUID;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class WorkflowWorker
implements DocumentWorker {
    private static final Logger LOG = LoggerFactory.getLogger(WorkflowWorker.class);
    private static final String TENANT_ID_KEY = "tenantId";
    private static final String CORRELATION_ID_KEY = "correlationId";
    private final WorkflowManager workflowManager;
    private final ScriptManager scriptManager;
    private final ArgumentsManager argumentsManager;
    private final FailureFieldsManager failureFieldsManager;

    public WorkflowWorker(WorkflowWorkerConfiguration workflowWorkerConfiguration, WorkflowManager workflowManager, ScriptManager scriptManager, ArgumentsManager argumentsManager, FailureFieldsManager failureFieldsManager) throws ConfigurationException {
        String workflowsDirectory = workflowWorkerConfiguration.getWorkflowsDirectory();
        if (workflowsDirectory == null) {
            throw new ConfigurationException("No workflow storage directory was set. Unable to load available workflows.");
        }
        this.workflowManager = workflowManager;
        this.scriptManager = scriptManager;
        this.argumentsManager = argumentsManager;
        this.failureFieldsManager = failureFieldsManager;
    }

    public void checkHealth(HealthMonitor healthMonitor) {
        try {
            this.argumentsManager.checkHealth();
        }
        catch (Exception e) {
            LOG.error("Problem encountered when contacting Settings Service to check health: ", (Throwable)e);
            healthMonitor.reportUnhealthy("Settings Service communication is unhealthy: " + e.getMessage());
        }
    }

    public void processDocument(Document document) throws DocumentWorkerTransientException {
        String workflowName;
        Workflow workflow;
        this.addMdcLoggingData(document.getTask());
        String customDataWorkflowName = document.getCustomData("workflowName");
        Field fieldWorkflowName = document.getField("CAF_WORKFLOW_NAME");
        if (!Strings.isNullOrEmpty((String)customDataWorkflowName)) {
            fieldWorkflowName.set(customDataWorkflowName);
        }
        if (!fieldWorkflowName.hasValues()) {
            LOG.error(String.format("Workflow could not be retrieved from custom data for document [%s].", document.getReference()));
            document.addFailure("WORKFLOW_NOT_SPECIFIED", "Workflow could not be retrieved from custom data.");
            return;
        }
        if (fieldWorkflowName.getValues().size() > 1) {
            LOG.error(String.format("Multiple workflows [%s] supplied in CAF_WORKFLOW_NAME field for document [%s].", String.join((CharSequence)",", fieldWorkflowName.getStringValues()), document.getReference()));
            document.addFailure("WORKFLOW_MULTIPLE_WORKFLOWS", "More than one workflow name was found in CAF_WORKFLOW_NAME field.");
        }
        if ((workflow = this.workflowManager.get(workflowName = (String)fieldWorkflowName.getStringValues().get(0))) == null) {
            String errorMessage = String.format("Workflow [%s] is not available for document [%s].", workflowName, document.getReference());
            LOG.error(errorMessage);
            document.addFailure("WORKFLOW_NOT_FOUND", errorMessage);
            return;
        }
        this.failureFieldsManager.handleExtraFailureSubFields(document);
        this.argumentsManager.addArgumentsToDocument(workflow.getArguments(), document);
        try {
            this.scriptManager.applyScriptToDocument(workflow, document);
        }
        catch (ScriptException e) {
            LOG.error(String.format("ScriptException for document [%s].\n%s\n", document.getReference(), e.toString()));
            document.addFailure("WORKFLOW_SCRIPT_EXCEPTION", e.getMessage());
        }
    }

    private void addMdcLoggingData(Task task) {
        String tenantId = task.getCustomData(TENANT_ID_KEY);
        String correlationId = WorkflowWorker.getOrCreateCorrelationId(task);
        if (tenantId != null) {
            MDC.put((String)TENANT_ID_KEY, (String)tenantId);
        }
        MDC.put((String)CORRELATION_ID_KEY, (String)correlationId);
        ResponseCustomData responseCustomData = task.getResponse().getCustomData();
        responseCustomData.put(TENANT_ID_KEY, tenantId);
        responseCustomData.put(CORRELATION_ID_KEY, correlationId);
    }

    private static String getOrCreateCorrelationId(Task task) {
        String correlationId = task.getCustomData(CORRELATION_ID_KEY);
        return correlationId == null ? UUID.randomUUID().toString() : correlationId;
    }
}

