/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.workflow;

import com.github.cafdataprocessing.workflow.ArgumentsManager;
import com.github.cafdataprocessing.workflow.FailureFieldsManager;
import com.github.cafdataprocessing.workflow.ScriptManager;
import com.github.cafdataprocessing.workflow.WorkflowManager;
import com.github.cafdataprocessing.workflow.WorkflowWorker;
import com.github.cafdataprocessing.workflow.WorkflowWorkerConfiguration;
import com.hpe.caf.api.ConfigurationException;
import com.hpe.caf.api.ConfigurationSource;
import com.hpe.caf.worker.document.exceptions.DocumentWorkerTransientException;
import com.hpe.caf.worker.document.extensibility.DocumentWorker;
import com.hpe.caf.worker.document.extensibility.DocumentWorkerFactory;
import com.hpe.caf.worker.document.model.Application;
import com.hpe.caf.worker.document.model.Document;
import com.hpe.caf.worker.document.model.HealthMonitor;

public final class WorkflowWorkerFactory
implements DocumentWorkerFactory {
    public DocumentWorker createDocumentWorker(Application application) {
        try {
            WorkflowWorkerConfiguration workflowWorkerConfiguration = (WorkflowWorkerConfiguration)((ConfigurationSource)application.getService(ConfigurationSource.class)).getConfiguration(WorkflowWorkerConfiguration.class);
            return new WorkflowWorker(workflowWorkerConfiguration, new WorkflowManager(application, workflowWorkerConfiguration.getWorkflowsDirectory(), workflowWorkerConfiguration.getContextScriptFilePath()), new ScriptManager(), new ArgumentsManager(workflowWorkerConfiguration.getSettingsServiceUrl()), new FailureFieldsManager());
        }
        catch (ConfigurationException ex) {
            return new DocumentWorker(){

                public void checkHealth(HealthMonitor healthMonitor) {
                    healthMonitor.reportUnhealthy("Unable to load workflows");
                }

                public void processDocument(Document document) throws InterruptedException, DocumentWorkerTransientException {
                    throw new RuntimeException("Worker unhealthy and unable to process message.");
                }
            };
        }
    }
}

