/*
 * Decompiled with CFR 0.152.
 */
package com.github.camellabs.component.pi4j.converter;

import com.github.camellabs.component.pi4j.i2c.driver.LSM303Value;
import com.pi4j.io.gpio.PinState;
import java.nio.ByteBuffer;
import org.apache.camel.Converter;

@Converter
public final class Pi4jConverter {
    private Pi4jConverter() {
    }

    @Converter
    public static PinState toPinState(String state) {
        for (PinState pin : PinState.allStates()) {
            if (!pin.getName().equals(state)) continue;
            return pin;
        }
        return null;
    }

    @Converter
    public static boolean pinStateToBoolean(PinState state) {
        return state.isHigh();
    }

    @Converter
    public static PinState booleanToPinState(boolean state) {
        return PinState.getState((boolean)state);
    }

    @Converter
    public static String[] stringToStringArray(String string) {
        return string.split(",");
    }

    @Converter
    public static byte[] LSM303ValuetoArray(LSM303Value value) {
        ByteBuffer ret = ByteBuffer.allocate(12);
        ret.putInt(value.getX());
        ret.putInt(value.getY());
        ret.putInt(value.getZ());
        return ret.array();
    }

    @Converter
    public static LSM303Value intArraytoLSM303Value(byte[] value) {
        LSM303Value ret = new LSM303Value();
        ByteBuffer b = ByteBuffer.wrap(value);
        ret.setX(b.getInt());
        ret.setY(b.getInt());
        ret.setZ(b.getInt());
        return ret;
    }
}

