/*
 * Decompiled with CFR 0.152.
 */
package com.github.camellabs.component.pi4j.gpio;

import com.github.camellabs.component.pi4j.gpio.GPIOEndpoint;
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPin;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPIOComponent
extends UriEndpointComponent {
    private static final transient Logger LOG = LoggerFactory.getLogger(GPIOComponent.class);
    private static final Object SYNC = GPIOComponent.class;
    private GpioController controller;

    public GPIOComponent() {
        super(GPIOEndpoint.class);
    }

    public GPIOComponent(CamelContext context) {
        super(context, GPIOEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        GPIOEndpoint endpoint = null;
        Pattern regexPattern = Pattern.compile("((?<scheme>pi4j-gpio)://)?(?<gpioId>[0-9A-Z_]+)");
        Matcher match = regexPattern.matcher(remaining);
        if (match.matches()) {
            endpoint = new GPIOEndpoint(uri, remaining, this, this.controller);
            parameters.put("gpioId", match.group("gpioId"));
            this.setProperties((Object)endpoint, parameters);
        }
        return endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        super.doStart();
        Object object = SYNC;
        synchronized (object) {
            if (this.controller == null) {
                this.controller = GpioFactory.getInstance();
            }
        }
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        if (this.controller != null) {
            GpioPin[] gpiopins = new GpioPin[this.controller.getProvisionedPins().size()];
            this.controller.getProvisionedPins().toArray(gpiopins);
            for (GpioPin pin : gpiopins) {
                this.controller.unprovisionPin(new GpioPin[]{pin});
            }
        }
    }

    public GpioController getController() {
        return this.controller;
    }

    public void setController(GpioController controller) {
        this.controller = controller;
    }
}

