/*
 * Decompiled with CFR 0.152.
 */
package com.github.camellabs.component.pi4j.gpio;

import com.github.camellabs.component.pi4j.gpio.GPIOEndpoint;
import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.GpioPinAnalogValueChangeEvent;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerAnalog;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultConsumer;

public class GPIOConsumer
extends DefaultConsumer
implements GpioPinListenerDigital,
GpioPinListenerAnalog {
    private final GPIOEndpoint endpoint;
    private final GpioPin pin;
    private final PinState state;

    public GPIOConsumer(GPIOEndpoint endpoint, Processor processor, GpioPin pin, PinState state) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.pin = pin;
        this.state = state;
    }

    protected void doStart() throws Exception {
        this.pin.addListener(new GpioPinListener[]{this});
        this.log.trace("Start Listening GPIO {}", (Object)this.pin.getPin().getAddress());
    }

    protected void doStop() throws Exception {
        this.pin.removeListener(new GpioPinListener[]{this});
        this.log.trace("Stop Listening GPIO {}", (Object)this.pin.getPin().getAddress());
    }

    public GpioPin getPin() {
        return this.pin;
    }

    public PinState getState() {
        return this.state;
    }

    public void handleGpioPinAnalogValueChangeEvent(GpioPinAnalogValueChangeEvent event) {
        Exchange exchange = this.endpoint.createExchange();
        exchange.getIn().setBody((Object)event);
        exchange.getIn().setHeader("CamelPi4j.pin", (Object)event.getPin());
        exchange.getIn().setHeader("CamelPi4j.pinValue", (Object)event.getValue());
        exchange.getIn().setHeader("CamelPi4j.pinType", (Object)event.getEventType());
        this.log.debug("GpioEvent pin {}, event {}, state {} ", new Object[]{event.getPin().getName(), event.getEventType().name(), event.getValue()});
        this.sendEvent(exchange);
    }

    public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
        this.log.debug("GpioEvent pin {}, event {}, state {} ", (Object[])new String[]{event.getPin().getName(), event.getEventType().name(), event.getState().getName()});
        if (this.state != null && this.state != event.getState()) {
            this.log.debug("Consumer state {} != {} Event state --> ignore Event", (Object)this.state, (Object)event.getState());
            return;
        }
        Exchange exchange = this.endpoint.createExchange();
        exchange.getIn().setBody((Object)event);
        exchange.getIn().setHeader("CamelPi4j.pin", (Object)event.getPin());
        exchange.getIn().setHeader("CamelPi4j.pinState", (Object)event.getState());
        exchange.getIn().setHeader("CamelPi4j.pinType", (Object)event.getEventType());
        this.sendEvent(exchange);
    }

    private void sendEvent(Exchange exchange) {
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        finally {
            if (exchange.getException() != null) {
                this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
            }
        }
    }
}

