/*
 * Decompiled with CFR 0.152.
 */
package com.github.camellabs.component.pi4j.gpio;

import com.github.camellabs.component.pi4j.gpio.GPIOAction;
import com.github.camellabs.component.pi4j.gpio.GPIOComponent;
import com.github.camellabs.component.pi4j.gpio.GPIOConsumer;
import com.github.camellabs.component.pi4j.gpio.GPIOProducer;
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinMode;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.RaspiPin;
import java.lang.reflect.Field;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="pi4j-gpio", syntax="pi4j-gpio://gpioId", consumerClass=GPIOConsumer.class, label="platform,iot", title="RaspberryPi")
public class GPIOEndpoint
extends DefaultEndpoint {
    private static final transient Logger LOG = LoggerFactory.getLogger(GPIOEndpoint.class);
    @UriPath(description="pin gpioId (pi4j and wiringpi index)")
    @Metadata(required="true")
    private String gpioId;
    @UriParam(description="Digital Only: if input mode then state trigger event, if output then started value")
    private PinState state = null;
    @UriParam(defaultValue="DIGITAL_OUTPUT", enums="DIGITAL_OUTPUT:DIGITAL_INPUT:PWM_OUTPUT:DIGITAL_OUTPUT:ANALOG_OUTPUT")
    @Metadata(required="true")
    private PinMode mode = PinMode.DIGITAL_OUTPUT;
    @UriParam(description="Default : use Body if Action for ouput Pin (TOGGLE, BLINK, HIGH, LOW for digital only) (HEADER digital and analog)", enums="TOGGLE:BLINK:HIGH:LOW:HEADER")
    private GPIOAction action;
    @UriParam(defaultValue="0", description="Analog or PWN Only")
    private double value;
    @UriParam(defaultValue="true", description="pin shutdown export")
    private boolean shutdownExport = true;
    @UriParam(defaultValue="LOW", description="pin state value before exit program")
    private PinState shutdownState = PinState.LOW;
    @UriParam(defaultValue="OFF", description="pin resistance before exit program")
    private PinPullResistance shutdownResistance = PinPullResistance.OFF;
    @UriParam(defaultValue="PULL_UP")
    private PinPullResistance pullResistance = PinPullResistance.PULL_UP;
    @UriParam(defaultValue="0")
    private long delay = 0L;
    @UriParam(defaultValue="50")
    private long duration = 50L;
    @UriParam(defaultValue="com.pi4j.io.gpio.RaspiPin")
    private Class gpioClass = RaspiPin.class;
    private GpioController controller;

    public GPIOEndpoint() {
    }

    public GPIOEndpoint(String uri, String pin, GPIOComponent component, GpioController crtl) {
        super(uri, (Component)component);
        ObjectHelper.notNull((Object)crtl, (String)"controller");
        this.controller = crtl;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        LOG.debug(this.toString());
        ObjectHelper.notNull((Object)this.mode, (String)"mode");
        GpioPin pin = this.isAlreadyProvisioned();
        if (pin == null) {
            switch (this.mode) {
                case DIGITAL_INPUT: {
                    pin = this.getOrCreateController().provisionDigitalInputPin(this.getPin(), this.pullResistance);
                    break;
                }
                case ANALOG_INPUT: {
                    pin = this.getOrCreateController().provisionAnalogInputPin(this.getPin());
                    break;
                }
                case ANALOG_OUTPUT: 
                case DIGITAL_OUTPUT: 
                case PWM_OUTPUT: {
                    LOG.error("Cannot create Consumer with OUTPUT Mode");
                    return null;
                }
                default: {
                    LOG.error("Cannot create Consumer w/o Mode");
                    break;
                }
            }
        } else {
            throw new IllegalArgumentException("Cannot create twice same input pin [" + this.gpioId + "] for Consumer");
        }
        return new GPIOConsumer(this, processor, pin, this.state);
    }

    public Producer createProducer() throws Exception {
        LOG.debug(this.toString());
        ObjectHelper.notNull((Object)this.mode, (String)"mode");
        GpioPin pin = this.isAlreadyProvisioned();
        if (pin == null) {
            switch (this.mode) {
                case DIGITAL_OUTPUT: {
                    pin = this.getOrCreateController().provisionDigitalOutputPin(this.getPin(), this.state);
                    break;
                }
                case ANALOG_OUTPUT: {
                    pin = this.getOrCreateController().provisionAnalogOutputPin(this.getPin(), this.value);
                    break;
                }
                case PWM_OUTPUT: {
                    pin = this.getOrCreateController().provisionPwmOutputPin(this.getPin(), (int)this.value);
                    break;
                }
                case DIGITAL_INPUT: 
                case ANALOG_INPUT: {
                    LOG.error("Cannot create Producer with INPUT Mode");
                    return null;
                }
                default: {
                    LOG.error("Cannot create Producer w/o Mode");
                }
            }
        } else {
            throw new IllegalArgumentException("Cannot create twice same output gpio [" + this.gpioId + "] for Producer");
        }
        pin.setMode(this.mode);
        return new GPIOProducer(this, pin, this.action);
    }

    public GPIOAction getAction() {
        return this.action;
    }

    public GpioController getController() {
        return this.controller;
    }

    public long getDelay() {
        return this.delay;
    }

    public long getDuration() {
        return this.duration;
    }

    public Class getGpioClass() {
        return this.gpioClass;
    }

    public String getGpioId() {
        return this.gpioId;
    }

    public PinMode getMode() {
        return this.mode;
    }

    public GpioController getOrCreateController() {
        return this.controller;
    }

    private Pin getPin() {
        Pin ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug(" Pin Id > " + this.gpioId);
        }
        if ((ret = this.getPinPerFieldName()) == null && (ret = this.getPinPerPinAddress()) == null) {
            ret = this.getPinPerPinName();
        }
        if (ret == null) {
            throw new IllegalArgumentException("Cannot find gpio [" + this.gpioId + "] ");
        }
        return ret;
    }

    private Pin getPinPerFieldName() {
        Pin ret = null;
        try {
            Field field = this.gpioClass.getDeclaredField(this.gpioId);
            ret = (Pin)field.get(null);
        }
        catch (NoSuchFieldException e) {
            LOG.trace(" Field " + this.gpioId + " not found in class " + this.gpioClass);
        }
        catch (SecurityException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return ret;
    }

    private Pin getPinPerPinAddress() {
        Pin ret = null;
        int address = -1;
        try {
            address = Integer.parseInt(this.gpioId);
        }
        catch (Exception e) {
            LOG.trace(" gpioId " + this.gpioId + " not an address");
            return ret;
        }
        for (Field field : this.gpioClass.getFields()) {
            if (!field.getType().equals(Pin.class)) continue;
            try {
                ret = (Pin)field.get(null);
                if (ret.getAddress() != address) continue;
                return ret;
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        LOG.trace(" Address " + this.gpioId + " not found in class " + this.gpioClass);
        return ret;
    }

    private Pin getPinPerPinName() {
        Pin ret = null;
        for (Field field : this.gpioClass.getFields()) {
            if (!field.getType().equals(Pin.class)) continue;
            try {
                ret = (Pin)field.get(null);
                if (ret.getName().compareTo(this.gpioId) != 0) continue;
                return ret;
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return ret;
    }

    public PinPullResistance getPullResistance() {
        return this.pullResistance;
    }

    public boolean getShutdownExport() {
        return this.shutdownExport;
    }

    public PinPullResistance getShutdownResistance() {
        return this.shutdownResistance;
    }

    public PinState getShutdownState() {
        return this.shutdownState;
    }

    public PinState getState() {
        return this.state;
    }

    public double getValue() {
        return this.value;
    }

    private GpioPin isAlreadyProvisioned() {
        GpioPin ret = null;
        for (GpioPin pin : this.getOrCreateController().getProvisionedPins()) {
            if (pin.getPin().getAddress() != Integer.parseInt(this.gpioId)) continue;
            ret = pin;
            break;
        }
        return ret;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setAction(GPIOAction action) {
        this.action = action;
    }

    public void setController(GpioController controller) {
        this.controller = controller;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setGpioClass(Class gpioClass) {
        this.gpioClass = gpioClass;
    }

    public void setGpioId(String gpioId) {
        this.gpioId = gpioId;
    }

    public void setMode(PinMode mode) {
        this.mode = mode;
    }

    public void setPullResistance(PinPullResistance pullResistance) {
        this.pullResistance = pullResistance;
    }

    public void setShutdownExport(boolean shutdownExport) {
        this.shutdownExport = shutdownExport;
    }

    public void setShutdownResistance(PinPullResistance shutdownResistance) {
        this.shutdownResistance = shutdownResistance;
    }

    public void setShutdownState(PinState shutdownState) {
        this.shutdownState = shutdownState;
    }

    public void setState(PinState state) {
        this.state = state;
    }

    public void setValue(double value) {
        this.value = value;
    }

    private void shutdownOption(GpioPin pin) {
        pin.setShutdownOptions(Boolean.valueOf(this.shutdownExport), this.shutdownState, this.shutdownResistance);
    }
}

