/*
 * Decompiled with CFR 0.152.
 */
package com.github.camellabs.component.pi4j.gpio;

import com.github.camellabs.component.pi4j.gpio.GPIOAction;
import com.github.camellabs.component.pi4j.gpio.GPIOEndpoint;
import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinAnalogOutput;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.GpioPinPwmOutput;
import com.pi4j.io.gpio.PinMode;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultProducer;

public class GPIOProducer
extends DefaultProducer {
    private GPIOEndpoint endpoint;
    private GpioPin pin;
    private GPIOAction action;
    private ExecutorService pool;

    public GPIOProducer(GPIOEndpoint endpoint, GpioPin pin, GPIOAction action) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.pin = pin;
        this.action = action;
    }

    public GpioPin getPin() {
        return this.pin;
    }

    private void output(Exchange exchange, Object value) {
        PinMode mode = this.pin.getMode();
        this.log.debug("Mode > " + mode + " for " + this.pin);
        switch (mode) {
            case DIGITAL_OUTPUT: {
                Boolean outputBoolean = (Boolean)exchange.getContext().getTypeConverter().convertTo(Boolean.class, value);
                ((GpioPinDigitalOutput)this.pin).setState(outputBoolean.booleanValue());
                break;
            }
            case ANALOG_OUTPUT: {
                Double outputDouble = (Double)exchange.getContext().getTypeConverter().convertTo(Double.class, value);
                ((GpioPinAnalogOutput)this.pin).setValue(outputDouble.doubleValue());
                break;
            }
            case PWM_OUTPUT: {
                Integer outputInt = (Integer)exchange.getContext().getTypeConverter().convertTo(Integer.class, value);
                ((GpioPinPwmOutput)this.pin).setPwm(outputInt.intValue());
                break;
            }
            case ANALOG_INPUT: 
            case DIGITAL_INPUT: {
                this.log.error("Cannot output with INPUT PinMode");
                break;
            }
            default: {
                this.log.error("Any PinMode found");
            }
        }
    }

    public void process(Exchange exchange) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace(exchange.toString());
        }
        if (this.action == null) {
            this.log.trace("No action pick up body");
            this.output(exchange, exchange.getIn().getBody());
        } else {
            this.log.trace("action= {} ", (Object)this.action);
            switch (this.action) {
                case TOGGLE: {
                    if (this.pin.getMode() != PinMode.DIGITAL_OUTPUT) break;
                    ((GpioPinDigitalOutput)this.pin).toggle();
                    break;
                }
                case LOW: {
                    if (this.pin.getMode() != PinMode.DIGITAL_OUTPUT) break;
                    ((GpioPinDigitalOutput)this.pin).low();
                    break;
                }
                case HIGH: {
                    if (this.pin.getMode() != PinMode.DIGITAL_OUTPUT) break;
                    ((GpioPinDigitalOutput)this.pin).high();
                    break;
                }
                case BLINK: {
                    if (this.pin.getMode() != PinMode.DIGITAL_OUTPUT) break;
                    this.pool = this.getEndpoint().getCamelContext().getExecutorServiceManager().newSingleThreadExecutor((Object)this, "gpio");
                    this.pool.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(GPIOProducer.this.endpoint.getDelay());
                                ((GpioPinDigitalOutput)GPIOProducer.this.pin).toggle();
                                Thread.sleep(GPIOProducer.this.endpoint.getDuration());
                                ((GpioPinDigitalOutput)GPIOProducer.this.pin).toggle();
                            }
                            catch (InterruptedException e) {
                                GPIOProducer.this.log.error("Thread interruption into BLINK sequence", (Throwable)e);
                            }
                        }
                    });
                    break;
                }
                default: {
                    this.log.error("Any action set found");
                }
            }
        }
    }

    public void setPin(GpioPin pin) {
        this.pin = pin;
    }
}

