/*
 * Decompiled with CFR 0.152.
 */
package com.github.camellabs.component.pi4j.i2c;

import com.github.camellabs.component.pi4j.i2c.I2CEndpoint;
import com.pi4j.io.i2c.I2CFactory;
import com.pi4j.io.i2c.I2CFactoryProvider;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I2CComponent
extends UriEndpointComponent {
    private static final transient Logger LOG = LoggerFactory.getLogger(I2CComponent.class);

    public I2CComponent() {
        super(I2CEndpoint.class);
    }

    public I2CComponent(CamelContext context) {
        super(context, I2CEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        I2CEndpoint endpoint = null;
        Pattern regexPattern = Pattern.compile("((?<scheme>pi4j-i2c)://)?(?<busId>(0x)?[0-9a-f]+)/(?<deviceId>(0x)?[0-9a-f]+)");
        Matcher match = regexPattern.matcher(remaining);
        if (match.matches()) {
            int busId = Integer.decode(match.group("busId"));
            int deviceId = Integer.decode(match.group("deviceId"));
            endpoint = new I2CEndpoint(uri, this, remaining, I2CFactory.getInstance((int)busId), parameters);
            parameters.put("busId", busId);
            parameters.put("deviceId", deviceId);
            this.setProperties((Object)endpoint, parameters);
        }
        return endpoint;
    }

    public void setProvider(I2CFactoryProvider provider) {
        I2CFactory.setFactory((I2CFactoryProvider)provider);
    }
}

