/*
 * Decompiled with CFR 0.152.
 */
package com.github.camellabs.component.pi4j.i2c;

import com.github.camellabs.component.pi4j.i2c.I2CEndpoint;
import com.pi4j.io.i2c.I2CDevice;
import java.io.IOException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.ScheduledPollConsumer;

public class I2CConsumer
extends ScheduledPollConsumer
implements I2CDevice {
    private final I2CEndpoint endpoint;
    private final I2CDevice device;

    public I2CConsumer(I2CEndpoint endpoint, Processor processor, I2CDevice device) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.device = device;
    }

    protected void createBody(Exchange exchange) throws IOException {
        byte[] buffer = null;
        if (this.endpoint.getReadAction() != null) {
            switch (this.endpoint.getReadAction()) {
                case READ: {
                    exchange.getIn().setBody((Object)this.read(), Integer.class);
                    break;
                }
                case READ_ADDR: {
                    exchange.getIn().setBody((Object)this.read(this.endpoint.getAddress()), Integer.class);
                    break;
                }
                case READ_BUFFER: {
                    buffer = new byte[this.endpoint.getBufferSize()];
                    this.read(buffer, this.endpoint.getOffset(), this.endpoint.getSize());
                    exchange.getIn().setBody((Object)buffer, byte[].class);
                    break;
                }
                case READ_ADDR_BUFFER: {
                    buffer = new byte[this.endpoint.getBufferSize()];
                    this.read(this.endpoint.getAddress(), buffer, this.endpoint.getOffset(), this.endpoint.getSize());
                    exchange.getIn().setBody((Object)buffer, byte[].class);
                    break;
                }
            }
        }
    }

    public I2CDevice getDevice() {
        return this.device;
    }

    protected int poll() throws Exception {
        Exchange exchange = this.endpoint.createExchange();
        try {
            this.createBody(exchange);
            this.getProcessor().process(exchange);
            int n = 1;
            return n;
        }
        finally {
            if (exchange.getException() != null) {
                this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
            }
        }
    }

    public int read() throws IOException {
        return this.device.read();
    }

    public int read(byte[] buffer, int offset, int size) throws IOException {
        return this.device.read(buffer, offset, size);
    }

    public int read(byte[] writeBuffer, int writeOffset, int writeSize, byte[] buffer, int offset, int size) throws IOException {
        return this.device.read(writeBuffer, writeOffset, writeSize, buffer, offset, size);
    }

    public int read(int address) throws IOException {
        return this.device.read(address);
    }

    public int readU16BigEndian(int register) throws IOException {
        int lo = this.read(register);
        int hi = this.read(register + 1);
        return (hi << 8) + lo;
    }

    public int readU16LittleEndian(int register) throws IOException {
        int lo = this.read(register);
        int hi = this.read(register + 1);
        return (lo << 8) + hi;
    }

    public int read(int address, byte[] buffer, int offset, int size) throws IOException {
        return this.device.read(address, buffer, offset, size);
    }

    public void write(byte b) throws IOException {
        this.device.write(b);
    }

    public void write(byte[] buffer, int offset, int size) throws IOException {
        this.device.write(buffer, offset, size);
    }

    public void write(int address, byte b) throws IOException {
        this.device.write(address, b);
    }

    public void write(int address, byte[] buffer, int offset, int size) throws IOException {
        this.device.write(address, buffer, offset, size);
    }

    public void sleep(long howMuch) {
        try {
            Thread.sleep(howMuch);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }
}

