/*
 * Decompiled with CFR 0.152.
 */
package com.github.camellabs.component.pi4j.i2c;

import com.github.camellabs.component.pi4j.i2c.I2CComponent;
import com.github.camellabs.component.pi4j.i2c.I2CConsumer;
import com.github.camellabs.component.pi4j.i2c.I2CProducer;
import com.github.camellabs.component.pi4j.i2c.I2CReadAction;
import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.I2CDevice;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.EndpointHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="pi4j-i2c", syntax="pi4j-i2c://busId/deviceId", consumerClass=I2CConsumer.class, label="iot", title="i2c")
public class I2CEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(I2CEndpoint.class);
    @UriPath
    @Metadata(required="true")
    private String name;
    @UriParam(defaultValue="")
    private int busId;
    @UriParam(defaultValue="")
    private int deviceId;
    @UriParam(defaultValue="0x00")
    private int address = 0;
    @UriParam(defaultValue="")
    private I2CReadAction readAction;
    @UriParam(defaultValue="-1")
    private int size = -1;
    @UriParam(defaultValue="-1")
    private int offset = -1;
    @UriParam(defaultValue="-1")
    private int bufferSize = -1;
    @UriParam(defaultValue="")
    private String driver;
    private Class driverClass;
    private Map<String, Object> parameters;
    private I2CDevice device;
    private I2CBus bus;

    public I2CEndpoint(String uri, I2CComponent i2cComponent, String remaining, I2CBus bus, Map<String, Object> parameters) {
        super(uri, (Component)i2cComponent);
        this.bus = bus;
        this.parameters = parameters;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        Consumer ret = null;
        this.initDriver(I2CConsumer.class);
        this.device = this.bus.getDevice(this.deviceId);
        Constructor constructor = this.driverClass.getConstructor(I2CEndpoint.class, Processor.class, I2CDevice.class);
        ret = (Consumer)constructor.newInstance(new Object[]{this, processor, this.device});
        EndpointHelper.setProperties((CamelContext)this.getCamelContext(), (Object)ret, this.parameters);
        if (!this.parameters.isEmpty()) {
            for (String param : this.parameters.keySet()) {
                LOG.warn("There are parameters that couldn't be set on the endpoint Consumer. Check the uri if the parameters are spelt correctly and that they are properties of the endpoint. Unknown Consumer parameters=[" + param + "]");
            }
        }
        return ret;
    }

    public Producer createProducer() throws Exception {
        Producer ret = null;
        this.initDriver(I2CProducer.class);
        this.device = this.bus.getDevice(this.deviceId);
        Constructor constructor = this.driverClass.getConstructor(I2CEndpoint.class, I2CDevice.class);
        ret = (Producer)constructor.newInstance(new Object[]{this, this.device});
        EndpointHelper.setProperties((CamelContext)this.getCamelContext(), (Object)ret, this.parameters);
        if (!this.parameters.isEmpty()) {
            for (String param : this.parameters.keySet()) {
                LOG.warn("There are parameters that couldn't be set on the endpoint Producer. Check the uri if the parameters are spelt correctly and that they are properties of the endpoint. Unknown Producer parameters=[" + param + "]");
            }
        }
        return ret;
    }

    public int getAddress() {
        return this.address;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public I2CBus getBus() {
        return this.bus;
    }

    public int getBusId() {
        return this.busId;
    }

    public I2CDevice getDevice() {
        return this.device;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getName() {
        return this.name;
    }

    public int getOffset() {
        return this.offset;
    }

    public I2CReadAction getReadAction() {
        return this.readAction;
    }

    public int getSize() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDriver(Class defaultClass) throws ClassNotFoundException, IOException {
        Object ret = null;
        if (this.driver != null && this.driver.compareTo("") != 0) {
            InputStream is = I2CEndpoint.class.getResourceAsStream("/META-INF/services/com/github/camellabs/component/pi4j/i2c/" + this.driver);
            StringBuilder sb = new StringBuilder();
            try (BufferedReader br = null;){
                String line;
                br = new BufferedReader(new InputStreamReader(is));
                while ((line = br.readLine()) != null) {
                    if (line.contains("#")) continue;
                    sb.append(line);
                }
            }
            this.driverClass = Class.forName(sb.toString());
        }
        if (this.driverClass == null) {
            this.driverClass = defaultClass;
        }
    }

    public boolean isLenientProperties() {
        return true;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setBus(I2CBus bus) {
        this.bus = bus;
    }

    public void setBusId(int busId) {
        this.busId = busId;
    }

    public void setDevice(I2CDevice device) {
        this.device = device;
    }

    public void setDeviceId(int deviceId) {
        this.deviceId = deviceId;
    }

    public void setDriver(String driverName) {
        this.driver = driverName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setReadAction(I2CReadAction readAction) {
        this.readAction = readAction;
    }

    public void setSize(int size) {
        this.size = size;
    }
}

