/*
 * Decompiled with CFR 0.152.
 */
package com.github.camellabs.component.pi4j.i2c;

import com.github.camellabs.component.pi4j.i2c.I2CEndpoint;
import com.pi4j.io.i2c.I2CDevice;
import java.io.IOException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I2CProducer
extends DefaultProducer
implements I2CDevice {
    private static final Logger LOG = LoggerFactory.getLogger(I2CProducer.class);
    protected I2CEndpoint endpoint;
    protected I2CDevice device;

    public I2CProducer(I2CEndpoint endpoint, I2CDevice device) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.device = device;
    }

    public void process(Exchange exchange) throws Exception {
        Object o = exchange.getIn().getBody();
        if (o instanceof Byte) {
            if (this.endpoint.getAddress() >= 0) {
                this.write(this.endpoint.getAddress(), (Byte)o);
            } else {
                this.write((Byte)o);
            }
        } else if (o instanceof Byte[]) {
            if (this.endpoint.getAddress() >= 0) {
                this.write(this.endpoint.getAddress(), (byte[])o, this.endpoint.getOffset(), this.endpoint.getSize());
            } else {
                this.write((byte[])o, this.endpoint.getOffset(), this.endpoint.getSize());
            }
        }
    }

    public int read() throws IOException {
        return this.device.read();
    }

    public int read(byte[] buffer, int offset, int size) throws IOException {
        return this.device.read(buffer, offset, size);
    }

    public int read(byte[] writeBuffer, int writeOffset, int writeSize, byte[] buffer, int offset, int size) throws IOException {
        return this.device.read(writeBuffer, writeOffset, writeSize, buffer, offset, size);
    }

    public int read(int address) throws IOException {
        return this.device.read(address);
    }

    public int readU16BigEndian(int register) throws IOException {
        int lo = this.read(register);
        int hi = this.read(register + 1);
        return (hi << 8) + lo;
    }

    public int readU16LittleEndian(int register) throws IOException {
        int lo = this.read(register);
        int hi = this.read(register + 1);
        return (lo << 8) + hi;
    }

    public int read(int address, byte[] buffer, int offset, int size) throws IOException {
        return this.device.read(address, buffer, offset, size);
    }

    public void write(byte b) throws IOException {
        this.device.write(b);
    }

    public void write(byte[] buffer, int offset, int size) throws IOException {
        this.device.write(buffer, offset, size);
    }

    public void write(int address, byte b) throws IOException {
        this.device.write(address, b);
    }

    public void write(int address, byte[] buffer, int offset, int size) throws IOException {
        this.device.write(address, buffer, offset, size);
    }

    public I2CDevice getDevice() {
        return this.device;
    }

    public void setDevice(I2CDevice device) {
        this.device = device;
    }

    public void sleep(long howMuch) {
        try {
            Thread.sleep(howMuch);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }
}

