/*
 * Decompiled with CFR 0.152.
 */
package com.github.camellabs.component.pi4j.i2c.driver;

import com.github.camellabs.component.pi4j.i2c.I2CConsumer;
import com.github.camellabs.component.pi4j.i2c.I2CEndpoint;
import com.github.camellabs.component.pi4j.i2c.driver.BMP180OperatingMode;
import com.github.camellabs.component.pi4j.i2c.driver.BMP180Value;
import com.pi4j.io.i2c.I2CDevice;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BMP180Consumer
extends I2CConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(BMP180Consumer.class);
    private static final int CALIBRATION_START = 170;
    private static final int CALIBRATION_END = 191;
    private static final short BMP085_CONTROL = 244;
    private static final short BMP085_TEMPDATA = 246;
    private static final short BMP085_PRESSUREDATA = 246;
    private static final byte BMP085_READTEMPCMD = 46;
    private static final byte BMP085_READPRESSURECMD = 52;
    private BMP180OperatingMode mode = BMP180OperatingMode.STANDARD;
    private short AC1;
    private short AC2;
    private short AC3;
    private int AC4;
    private int AC5;
    private int AC6;
    private short B1;
    private short B2;
    private short MC;
    private short MD;

    public BMP180Consumer(I2CEndpoint endpoint, Processor processor, I2CDevice device) {
        super(endpoint, processor, device);
    }

    @Override
    protected void createBody(Exchange exchange) throws IOException {
        BMP180Value body = new BMP180Value();
        body.setPressure(this.readPressure());
        body.setTemperature(this.readTemperature());
        LOG.debug("" + body);
        exchange.getIn().setBody((Object)body);
    }

    protected void doStart() throws Exception {
        super.doStart();
        int totalBytes = 22;
        byte[] bytes = new byte[totalBytes];
        int bytesRead = this.read(170, bytes, 0, totalBytes);
        if (bytesRead != totalBytes) {
            throw new IOException("Could not read calibration data. Read " + bytes + " of " + totalBytes);
        }
        DataInputStream calibrationData = new DataInputStream(new ByteArrayInputStream(bytes));
        this.AC1 = calibrationData.readShort();
        this.AC2 = calibrationData.readShort();
        this.AC3 = calibrationData.readShort();
        this.AC4 = calibrationData.readUnsignedShort();
        this.AC5 = calibrationData.readUnsignedShort();
        this.AC6 = calibrationData.readUnsignedShort();
        this.B1 = calibrationData.readShort();
        this.B2 = calibrationData.readShort();
        calibrationData.readShort();
        this.MC = calibrationData.readShort();
        this.MD = calibrationData.readShort();
        LOG.debug(String.format("AC1:%d, AC2:%d, AC3:%d, AC4:%d, AC5:%d, AC6:%d, B1:%d, B2:%d, MC:%d, MD:%d", this.AC1, this.AC2, this.AC3, this.AC4, this.AC5, this.AC6, this.B1, this.B2, this.MC, this.MD));
    }

    public BMP180OperatingMode getMode() {
        return this.mode;
    }

    public int readPressure() throws IOException {
        long p = 0L;
        int UT = this.readRawTemp();
        int UP = this.readRawPressure();
        int X1 = (UT - this.AC6) * this.AC5 >> 15;
        int X2 = (this.MC << 11) / (X1 + this.MD);
        int B5 = X1 + X2;
        int B6 = B5 - 4000;
        X1 = this.B2 * (B6 * B6 >> 12) >> 11;
        X2 = this.AC2 * B6 >> 11;
        int X3 = X1 + X2;
        int B3 = ((this.AC1 * 4 + X3 << this.mode.getOverSamplingSetting()) + 2) / 4;
        X1 = this.AC3 * B6 >> 13;
        X2 = this.B1 * (B6 * B6 >> 12) >> 16;
        X3 = X1 + X2 + 2 >> 2;
        long B4 = (long)this.AC4 * (long)(X3 + 32768) >> 15;
        long B7 = ((long)UP - (long)B3) * (long)(50000 >> this.mode.getOverSamplingSetting());
        p = B7 < Integer.MIN_VALUE ? B7 * 2L / B4 : B7 / B4 * 2L;
        X1 = (int)((p >> 8) * (p >> 8));
        X1 = X1 * 3038 >> 16;
        X2 = (int)(-7357L * p) >> 16;
        return (int)(p += (long)(X1 + X2 + 3791 >> 4));
    }

    private int readRawPressure() throws IOException {
        this.write(244, (byte)52);
        this.sleep(this.mode.getWaitTime());
        return this.readU3(246) >> 8 - this.mode.getOverSamplingSetting();
    }

    private int readRawTemp() throws IOException {
        this.write(244, (byte)46);
        this.sleep(50L);
        return this.readU16LittleEndian(246);
    }

    private float readTemperature() throws IOException {
        int UT = this.readRawTemp();
        int X1 = (UT - this.AC6) * this.AC5 >> 15;
        int X2 = (this.MC << 11) / (X1 + this.MD);
        int B5 = X1 + X2;
        return (float)(B5 + 8 >> 4) / 10.0f;
    }

    private int readU3(int address) throws IOException {
        int msb = this.read(address);
        int lsb = this.read(address + 1);
        int xlsb = this.read(address + 2);
        return (msb << 16) + (lsb << 8) + xlsb;
    }

    public void setMode(BMP180OperatingMode mode) {
        this.mode = mode;
    }
}

