/*
 * Decompiled with CFR 0.152.
 */
package com.github.camellabs.component.pi4j.i2c.driver;

import com.github.camellabs.component.pi4j.i2c.I2CConsumer;
import com.github.camellabs.component.pi4j.i2c.I2CEndpoint;
import com.github.camellabs.component.pi4j.i2c.driver.LSM303Value;
import com.pi4j.io.i2c.I2CDevice;
import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LSM303AccelerometerConsumer
extends I2CConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(LSM303AccelerometerConsumer.class);
    public static final int LSM303_ADDRESS_ACCEL = 25;
    public static final int LSM303_REGISTER_ACCEL_CTRL_REG1_A = 32;
    public static final int LSM303_REGISTER_ACCEL_CTRL_REG4_A = 35;
    public static final int LSM303_REGISTER_ACCEL_OUT_X_L_A = 40;

    public LSM303AccelerometerConsumer(I2CEndpoint endpoint, Processor processor, I2CDevice device) {
        super(endpoint, processor, device);
    }

    private int accel12(byte[] list, int idx) {
        int n = 0xFF & list[idx] | (0xFF & list[idx + 1]) << 8;
        if (n > Short.MAX_VALUE) {
            n -= 65536;
        }
        return n >> 4;
    }

    @Override
    protected void createBody(Exchange exchange) throws IOException {
        LSM303Value body = this.readingSensors();
        LOG.debug("" + body);
        exchange.getIn().setBody((Object)body);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.getDevice().write(32, (byte)39);
        this.getDevice().write(35, (byte)8);
    }

    private LSM303Value readingSensors() throws IOException {
        LSM303Value ret = new LSM303Value();
        byte[] accelData = new byte[]{0, 0, 0, 0, 0, 0};
        int r = this.getDevice().read(168, accelData, 0, 6);
        if (r != 6) {
            System.out.println("Error reading accel data, < 6 bytes");
        }
        ret.setX(this.accel12(accelData, 0));
        ret.setY(this.accel12(accelData, 2));
        ret.setZ(this.accel12(accelData, 4));
        return ret;
    }
}

