/*
 * Decompiled with CFR 0.152.
 */
package com.github.camellabs.component.pi4j.i2c.driver;

import com.github.camellabs.component.pi4j.i2c.I2CConsumer;
import com.github.camellabs.component.pi4j.i2c.I2CEndpoint;
import com.github.camellabs.component.pi4j.i2c.driver.LSM303Value;
import com.pi4j.io.i2c.I2CDevice;
import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LSM303MagnetometerConsumer
extends I2CConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(LSM303MagnetometerConsumer.class);
    public static final int LSM303_ADDRESS_MAG = 30;
    public static final int LSM303_REGISTER_MAG_CRB_REG_M = 1;
    public static final int LSM303_REGISTER_MAG_MR_REG_M = 2;
    public static final int LSM303_REGISTER_MAG_OUT_X_H_M = 3;
    public static final int LSM303_MAGGAIN_1_3 = 32;
    public static final int LSM303_MAGGAIN_1_9 = 64;
    public static final int LSM303_MAGGAIN_2_5 = 96;
    public static final int LSM303_MAGGAIN_4_0 = 128;
    public static final int LSM303_MAGGAIN_4_7 = 160;
    public static final int LSM303_MAGGAIN_5_6 = 192;
    public static final int LSM303_MAGGAIN_8_1 = 224;
    private int gain = 32;

    public LSM303MagnetometerConsumer(I2CEndpoint endpoint, Processor processor, I2CDevice device) {
        super(endpoint, processor, device);
    }

    @Override
    protected void createBody(Exchange exchange) throws IOException {
        LSM303Value body = this.readingSensors();
        LOG.debug("" + body);
        exchange.getIn().setBody((Object)body);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.getDevice().write(2, (byte)0);
        this.getDevice().write(1, (byte)this.gain);
    }

    public int getGain() {
        return this.gain;
    }

    private int mag16(byte[] list, int idx) {
        int n = list[idx] << 8 | list[idx + 1];
        return n < 32768 ? n : n - 65536;
    }

    private LSM303Value readingSensors() throws IOException {
        LSM303Value ret = new LSM303Value();
        byte[] magData = new byte[6];
        int r = this.getDevice().read(3, magData, 0, 6);
        if (r != 6) {
            System.out.println("Error reading mag data, < 6 bytes");
        }
        ret.setX(this.mag16(magData, 0));
        ret.setY(this.mag16(magData, 2));
        ret.setZ(this.mag16(magData, 4));
        return ret;
    }

    public void setGain(int gain) {
        this.gain = gain;
    }
}

