/*
 * Decompiled with CFR 0.152.
 */
package com.github.camellabs.component.pi4j.i2c.driver;

import com.github.camellabs.component.pi4j.i2c.I2CEndpoint;
import com.github.camellabs.component.pi4j.i2c.I2CProducer;
import com.github.camellabs.component.pi4j.i2c.driver.MCP23017LCDColor;
import com.pi4j.io.i2c.I2CDevice;
import java.io.IOException;
import org.apache.camel.Exchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MCP23017LCD
extends I2CProducer {
    private static final Logger LOG = LoggerFactory.getLogger(MCP23017LCD.class);
    public static final String LCD_BLINK_CURSOR = "CamelLCDBlinkCursor";
    public static final String LCD_CURSOR = "CamelLCDCursor";
    public static final String LCD_COLOR = "CamelLCDColor";
    private static final int LCD_CLEARDISPLAY = 1;
    private static final int LCD_RETURNHOME = 2;
    private static final int LCD_ENTRYMODESET = 4;
    private static final int LCD_DISPLAYCONTROL = 8;
    private static final int LCD_CURSORSHIFT = 16;
    private static final int LCD_SETDDRAMADDR = 128;
    private static final int LCD_DISPLAYON = 4;
    private static final int LCD_CURSORON = 2;
    private static final int LCD_CURSOROFF = 0;
    private static final int LCD_BLINKON = 1;
    private static final int LCD_BLINKOFF = 0;
    private static final int LCD_ENTRYLEFT = 2;
    private static final int LCD_ENTRYSHIFTINCREMENT = 1;
    private static final int LCD_ENTRYSHIFTDECREMENT = 0;
    private static final int LCD_DISPLAYMOVE = 8;
    private static final int LCD_CURSORMOVE = 0;
    private static final int LCD_MOVERIGHT = 4;
    private static final int LCD_MOVELEFT = 0;
    private static final int MCP23017_IOCON_BANK0 = 10;
    private static final int MCP23017_IOCON_BANK1 = 21;
    private static final int MCP23017_GPIOA = 9;
    private static final int MCP23017_IODIRB = 16;
    private static final int MCP23017_GPIOB = 25;
    private static final int[] SHIFT_REVERSE = new int[]{0, 16, 8, 24, 4, 20, 12, 28, 2, 18, 10, 26, 6, 22, 14, 30};
    private static final int[] ROW_OFFSETS = new int[]{0, 64, 20, 84};
    private int portA = 0;
    private int portB = 0;
    private int ddrB = 16;
    private int displayShift = 4;
    private int displayMode = 2;
    private int displayControl = 4;
    private MCP23017LCDColor color = MCP23017LCDColor.WHITE;
    private String startupText = "Ready ";
    private boolean clearOnEachMessage = true;

    public MCP23017LCD(I2CEndpoint endpoint, I2CDevice device) {
        super(endpoint, device);
    }

    private void clear() throws IOException {
        this.internalWrite(1);
    }

    protected void doStart() throws Exception {
        LOG.debug("doStart");
        this.write(21, (byte)0);
        byte[] registers = new byte[]{63, (byte)this.ddrB, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, (byte)this.portA, (byte)this.portB, (byte)this.portA, (byte)this.portB};
        this.write(0, registers, 0, registers.length);
        this.write(10, (byte)-96);
        this.internalWrite(51);
        this.internalWrite(50);
        this.internalWrite(40);
        this.internalWrite(1);
        this.internalWrite(0x10 | this.displayShift);
        this.internalWrite(4 | this.displayMode);
        this.internalWrite(8 | this.displayControl);
        this.internalWrite(2);
        this.setColor(this.color);
        this.writeTextToDevice(this.startupText);
    }

    protected void doStop() throws Exception {
        this.writeTextToDevice("");
        this.portA = 192;
        this.portB = 1;
        this.sleep(2L);
        this.write(21, (byte)0);
        byte[] registers = new byte[]{63, (byte)this.ddrB, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, (byte)this.portA, (byte)this.portB, (byte)this.portA, (byte)this.portB};
        this.write(0, registers, 0, registers.length);
    }

    public MCP23017LCDColor getColor() {
        return this.color;
    }

    public String getStartupText() {
        return this.startupText;
    }

    private void home() throws IOException {
        this.internalWrite(2);
    }

    private void internalWrite(int value) throws IOException {
        this.waitOnLCDBusyFlag();
        int bitmask = this.portB & 1;
        byte[] data = this.out4(bitmask, value);
        this.write(25, data, 0, 4);
        this.portB = data[3];
        if (value == 1 || value == 2) {
            this.ddrB |= 0x10;
            this.write(16, (byte)this.ddrB);
        }
    }

    public boolean isAutoScroll() {
        return (this.displayControl & 1) > 0;
    }

    private boolean isBlinkCursor() {
        return (this.displayControl & 1) > 0;
    }

    public boolean isClearOnEachMessage() {
        return this.clearOnEachMessage;
    }

    private boolean isCursor() {
        return (this.displayControl & 2) > 0;
    }

    private boolean isDisplay() {
        return (this.displayControl & 4) > 0;
    }

    private void manageProperties(Exchange exchange) throws IOException {
        Boolean blink;
        Boolean cursor;
        MCP23017LCDColor color = (MCP23017LCDColor)((Object)exchange.getIn().getHeader(LCD_COLOR, MCP23017LCDColor.class));
        if (color != null) {
            this.setColor(color);
        }
        if ((cursor = (Boolean)exchange.getIn().getHeader(LCD_CURSOR, Boolean.class)) != null) {
            this.setCursor(cursor);
        }
        if ((blink = (Boolean)exchange.getIn().getHeader(LCD_BLINK_CURSOR, Boolean.class)) != null) {
            this.setBlinkCursor(blink);
        }
    }

    private byte[] out4(int bitmask, int value) {
        int hi = bitmask | SHIFT_REVERSE[value >> 4];
        int lo = bitmask | SHIFT_REVERSE[value & 0xF];
        return new byte[]{(byte)(hi | 0x20), (byte)hi, (byte)(lo | 0x20), (byte)lo};
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        this.manageProperties(exchange);
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> " + exchange.toString());
        }
        if (this.clearOnEachMessage) {
            this.clear();
        }
        this.setText((String)exchange.getIn().getBody(String.class));
    }

    private void scrollDisplay(Direction direction) throws IOException {
        if (direction == Direction.LEFT) {
            this.displayShift = 8;
            this.internalWrite(0x10 | this.displayShift);
        } else {
            this.displayShift = 12;
            this.internalWrite(0x10 | this.displayShift);
        }
    }

    public void setAutoScroll(boolean enable) throws IOException {
        if (enable) {
            this.displayMode |= 1;
            this.internalWrite(4 | this.displayMode);
        } else {
            this.displayMode &= 0xFFFFFFFE;
            this.internalWrite(4 | this.displayMode);
        }
    }

    public void setBlinkCursor(boolean enable) throws IOException {
        if (enable) {
            this.displayControl |= 1;
            this.internalWrite(8 | this.displayControl);
        } else {
            this.displayControl &= 0xFFFFFFFE;
            this.internalWrite(8 | this.displayControl);
        }
    }

    public void setClearOnEachMessage(boolean clearOnEachMessage) {
        this.clearOnEachMessage = clearOnEachMessage;
    }

    public void setColor(MCP23017LCDColor color) throws IOException {
        int c = ~color.getValue();
        this.portA = this.portA & 0x3F | (c & 3) << 6;
        this.portB = this.portB & 0xFE | (c & 4) >> 2;
        this.getDevice().write(9, (byte)this.portA);
        this.getDevice().write(25, (byte)this.portB);
        this.color = color;
    }

    public void setCursor(boolean enable) throws IOException {
        if (enable) {
            this.displayControl |= 2;
            this.internalWrite(8 | this.displayControl);
        } else {
            this.displayControl &= 0xFFFFFFFD;
            this.internalWrite(8 | this.displayControl);
        }
    }

    private void setCursorPosition(int row, int column) throws IOException {
        this.internalWrite(0x80 | column + ROW_OFFSETS[row]);
    }

    public void setDisplay(boolean enable) throws IOException {
        if (enable) {
            this.displayControl |= 4;
            this.internalWrite(8 | this.displayControl);
        } else {
            this.displayControl &= 0xFFFFFFFB;
            this.internalWrite(8 | this.displayControl);
        }
    }

    public void setStartupText(String startupText) {
        this.startupText = startupText;
    }

    private void setText(int row, String string) throws IOException {
        this.setCursorPosition(row, 0);
        this.writeTextToDevice(string);
    }

    private void setText(String s) throws IOException {
        String[] str = s.split("\n");
        for (int i = 0; i < str.length; ++i) {
            this.setText(i, str[i]);
        }
    }

    private void setTextFlowDirection(Direction direction) throws IOException {
        if (direction == Direction.LEFT) {
            this.displayMode &= 0xFFFFFFFD;
            this.internalWrite(4 | this.displayMode);
        } else {
            this.displayMode |= 2;
            this.internalWrite(4 | this.displayMode);
        }
    }

    private void waitOnLCDBusyFlag() throws IOException {
        if ((this.ddrB & 0x10) != 0) {
            int bits;
            int lo = this.portB & 1 | 0x40;
            int hi = lo | 0x20;
            this.write(25, (byte)lo);
            do {
                this.write((byte)hi);
                bits = this.read();
                this.getDevice().write(25, new byte[]{(byte)lo, (byte)hi, (byte)lo}, 0, 3);
            } while ((bits & 2) != 0);
            this.portB = lo;
            this.ddrB &= 0xEF;
            this.write(16, (byte)this.ddrB);
        }
    }

    private void writeTextToDevice(String s) throws IOException {
        int sLen = s.length();
        int bytesLen = 4 * sLen;
        if (sLen < 1) {
            return;
        }
        this.waitOnLCDBusyFlag();
        int bitmask = this.portB & 1;
        bitmask |= 0x80;
        byte[] bytes = new byte[4 * sLen];
        for (int i = 0; i < sLen; ++i) {
            byte[] data = this.out4(bitmask, s.charAt(i));
            for (int j = 0; j < 4; ++j) {
                bytes[i * 4 + j] = data[j];
            }
        }
        this.getDevice().write(25, bytes, 0, bytesLen);
        this.portB = bytes[bytesLen - 1];
    }

    public static enum Direction {
        LEFT,
        RIGHT;

    }
}

