/*
 * Decompiled with CFR 0.152.
 */
package com.github.camellabs.component.pi4j.i2c.driver;

import com.github.camellabs.component.pi4j.i2c.I2CConsumer;
import com.github.camellabs.component.pi4j.i2c.I2CEndpoint;
import com.github.camellabs.component.pi4j.i2c.driver.TSL2561Gain;
import com.github.camellabs.component.pi4j.i2c.driver.TSL2561IntegrationTime;
import com.github.camellabs.component.pi4j.i2c.driver.TSL2561Value;
import com.pi4j.io.i2c.I2CDevice;
import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSL2561Consumer
extends I2CConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(TSL2561Consumer.class);
    public static final int TSL2561_ADDRESS = 57;
    public static final int TSL2561_ADDRESS_LOW = 41;
    public static final int TSL2561_ADDRESS_FLOAT = 57;
    public static final int TSL2561_ADDRESS_HIGH = 73;
    public static final int TSL2561_COMMAND_BIT = 128;
    public static final int TSL2561_WORD_BIT = 32;
    public static final int TSL2561_CONTROL_POWERON = 3;
    public static final int TSL2561_CONTROL_POWEROFF = 0;
    public static final int TSL2561_REGISTER_CONTROL = 0;
    public static final int TSL2561_REGISTER_TIMING = 1;
    public static final int TSL2561_REGISTER_CHAN0_LOW = 12;
    public static final int TSL2561_REGISTER_CHAN0_HIGH = 13;
    public static final int TSL2561_REGISTER_CHAN1_LOW = 14;
    public static final int TSL2561_REGISTER_CHAN1_HIGH = 15;
    public static final int TSL2561_REGISTER_ID = 10;
    public static final double TSL2561_LUX_K1C = 0.13;
    public static final double TSL2561_LUX_B1C = 0.0315;
    public static final double TSL2561_LUX_M1C = 0.0262;
    public static final double TSL2561_LUX_K2C = 0.26;
    public static final double TSL2561_LUX_B2C = 0.0337;
    public static final double TSL2561_LUX_M2C = 0.043;
    public static final double TSL2561_LUX_K3C = 0.39;
    public static final double TSL2561_LUX_B3C = 0.0363;
    public static final double TSL2561_LUX_M3C = 0.0529;
    public static final double TSL2561_LUX_K4C = 0.52;
    public static final double TSL2561_LUX_B4C = 0.0392;
    public static final double TSL2561_LUX_M4C = 0.0605;
    public static final double TSL2561_LUX_K5C = 0.65;
    public static final double TSL2561_LUX_B5C = 0.0229;
    public static final double TSL2561_LUX_M5C = 0.0291;
    public static final double TSL2561_LUX_K6C = 0.8;
    public static final double TSL2561_LUX_B6C = 0.0157;
    public static final double TSL2561_LUX_M6C = 0.018;
    public static final double TSL2561_LUX_K7C = 1.3;
    public static final double TSL2561_LUX_B7C = 0.00338;
    public static final double TSL2561_LUX_M7C = 0.0026;
    public static final double TSL2561_LUX_K8C = 1.3;
    public static final double TSL2561_LUX_B8C = 0.0;
    public static final double TSL2561_LUX_M8C = 0.0;
    private TSL2561Gain gain = TSL2561Gain.GAIN_1X;
    private TSL2561IntegrationTime integration = TSL2561IntegrationTime.INTEGRATIONTIME_402MS;
    private long pause = 800L;

    public TSL2561Consumer(I2CEndpoint endpoint, Processor processor, I2CDevice device) {
        super(endpoint, processor, device);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.write(128, (byte)3);
        this.write(129, (byte)(this.gain.gain | this.integration.integrationTime));
        this.sleep(this.pause);
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.write(128, (byte)0);
    }

    @Override
    protected void createBody(Exchange exchange) throws IOException {
        TSL2561Value body = new TSL2561Value();
        body.setLux(this.readLux());
        LOG.debug("" + body);
        exchange.getIn().setBody((Object)body);
    }

    public double readLux() throws IOException {
        int ambient = this.readU16BigEndian(140);
        int ir = this.readU16BigEndian(142);
        if (ambient >= 65535 || ir >= 65535) {
            throw new RuntimeException("Gain too high. Values exceed range.");
        }
        double ratio = (float)ir / (float)ambient;
        LOG.debug("IR Result:" + ir);
        LOG.debug("Ambient Result:" + ambient);
        double lux = 0.0;
        if (ratio >= 0.0 && ratio <= 0.52) {
            lux = 0.0315 * (double)ambient - 0.0593 * (double)ambient * Math.pow(ratio, 1.4);
        } else if (ratio <= 0.65) {
            lux = 0.0229 * (double)ambient - 0.0291 * (double)ir;
        } else if (ratio <= 0.8) {
            lux = 0.0157 * (double)ambient - 0.018 * (double)ir;
        } else if (ratio <= 1.3) {
            lux = 0.00338 * (double)ambient - 0.0026 * (double)ir;
        } else if (ratio > 1.3) {
            lux = 0.0;
        }
        return lux;
    }

    public TSL2561Gain getGain() {
        return this.gain;
    }

    public void setGain(TSL2561Gain gain) {
        this.gain = gain;
    }

    public TSL2561IntegrationTime getIntegration() {
        return this.integration;
    }

    public void setIntegration(TSL2561IntegrationTime integration) {
        this.integration = integration;
    }

    public long getPause() {
        return this.pause;
    }

    public void setPause(long pause) {
        this.pause = pause;
    }
}

