/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.common;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class ConfigUtils {
    public static Map<String, List<String>> breakDownHeaders(String headers) {
        return ConfigUtils.breakDownMultiValuePairs(headers, ",", ":");
    }

    public static Map<String, List<String>> breakDownQueryParams(String queryParams) {
        return ConfigUtils.breakDownMultiValuePairs(queryParams, "&", "=");
    }

    public static Map<String, String> breakDownMap(String mapString) {
        return ConfigUtils.breakDownPairs(mapString, ",", "=");
    }

    public static List<Map<String, String>> breakDownMapList(String mapList) {
        return ConfigUtils.breakDownList(mapList, ";").map(ConfigUtils::breakDownMap).collect(Collectors.toList());
    }

    private static Map<String, String> breakDownPairs(String itemLine, String itemSplitter, String pairSplitter) {
        return ConfigUtils.breakDownPairs(itemLine, itemSplitter, pairSplitter, Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Map<String, List<String>> breakDownMultiValuePairs(String itemLine, String itemSplitter, String pairSplitter) {
        return ConfigUtils.breakDownPairs(itemLine, itemSplitter, pairSplitter, Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    private static <T> Map<String, T> breakDownPairs(String itemList, String itemSplitter, String pairSplitter, Collector<Map.Entry<String, String>, ?, Map<String, T>> collector) {
        return ConfigUtils.breakDownList(itemList, itemSplitter).map(headerLine -> ConfigUtils.breakDownPair(headerLine, pairSplitter)).collect(collector);
    }

    private static Map.Entry<String, String> breakDownPair(String pairLine, String pairSplitter) {
        String[] parts = pairLine.split(pairSplitter, 2);
        if (parts.length < 2) {
            throw new IllegalStateException("Incomplete pair: " + pairLine);
        }
        return new AbstractMap.SimpleEntry<String, String>(parts[0].trim(), parts[1].trim());
    }

    public static List<String> breakDownList(String itemList) {
        return ConfigUtils.breakDownList(itemList, ",").collect(Collectors.toList());
    }

    private static Stream<String> breakDownList(String itemList, String splitter) {
        if (itemList == null || itemList.length() == 0) {
            return Stream.empty();
        }
        return Stream.of(itemList.split(splitter)).map(String::trim).filter(it -> !it.isEmpty());
    }

    public static Set<Integer> parseIntegerRangedList(String rangedList) {
        return ConfigUtils.breakDownList(rangedList, ",").map(ConfigUtils::parseIntegerRange).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static Set<Integer> parseIntegerRange(String range) {
        String[] rangeString = range.split("\\.\\.");
        if (rangeString.length == 0 || rangeString[0].length() == 0) {
            return Collections.emptySet();
        }
        if (rangeString.length == 1) {
            return ConfigUtils.asSet(Integer.valueOf(rangeString[0].trim()));
        }
        if (rangeString.length == 2) {
            int to;
            int from = Integer.parseInt(rangeString[0].trim());
            return (from < (to = Integer.parseInt(rangeString[1].trim())) ? IntStream.rangeClosed(from, to) : IntStream.rangeClosed(to, from)).boxed().collect(Collectors.toSet());
        }
        throw new IllegalStateException(String.format("Invalid range definition %s", range));
    }

    private static Set<Integer> asSet(Integer ... values) {
        return Stream.of(values).collect(Collectors.toSet());
    }

    private ConfigUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

