/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.common;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersionUtils {
    private static final Logger log = LoggerFactory.getLogger(VersionUtils.class);
    private static final String DEFAULT_VERSION = "0.0.0.0";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getVersion() {
        try (InputStream input = VersionUtils.openFile("version.properties");){
            Properties properties = new Properties();
            properties.load(input);
            String string = properties.getProperty("version", DEFAULT_VERSION);
            return string;
        }
        catch (Exception ex) {
            log.warn("Error loading version.properties, default version 0.0.0.0 will be used");
            return DEFAULT_VERSION;
        }
    }

    private static InputStream openFile(String fileName) throws IOException {
        InputStream stream = VersionUtils.class.getClassLoader().getResourceAsStream(fileName);
        return stream != null ? stream : Files.newInputStream(Paths.get(fileName, new String[0]), new OpenOption[0]);
    }

    private VersionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

