/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.http;

import com.github.castorm.kafka.connect.common.ConfigUtils;
import com.github.castorm.kafka.connect.http.client.okhttp.OkHttpClient;
import com.github.castorm.kafka.connect.http.client.spi.HttpClient;
import com.github.castorm.kafka.connect.http.record.OffsetRecordFilterFactory;
import com.github.castorm.kafka.connect.http.record.OrderDirectionSourceRecordSorter;
import com.github.castorm.kafka.connect.http.record.spi.SourceRecordFilterFactory;
import com.github.castorm.kafka.connect.http.record.spi.SourceRecordSorter;
import com.github.castorm.kafka.connect.http.request.spi.HttpRequestFactory;
import com.github.castorm.kafka.connect.http.request.template.TemplateHttpRequestFactory;
import com.github.castorm.kafka.connect.http.response.PolicyHttpResponseParser;
import com.github.castorm.kafka.connect.http.response.spi.HttpResponseParser;
import com.github.castorm.kafka.connect.timer.AdaptableIntervalTimer;
import com.github.castorm.kafka.connect.timer.TimerThrottler;
import com.github.castorm.kafka.connect.timer.spi.Timer;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

class HttpSourceConnectorConfig
extends AbstractConfig {
    private static final String TIMER = "http.timer";
    private static final String CLIENT = "http.client";
    private static final String REQUEST_FACTORY = "http.request.factory";
    private static final String RESPONSE_PARSER = "http.response.parser";
    private static final String RECORD_SORTER = "http.record.sorter";
    private static final String RECORD_FILTER_FACTORY = "http.record.filter.factory";
    private static final String OFFSET_INITIAL = "http.offset.initial";
    private final TimerThrottler throttler;
    private final HttpRequestFactory requestFactory;
    private final HttpClient client;
    private final HttpResponseParser responseParser;
    private final SourceRecordFilterFactory recordFilterFactory;
    private final SourceRecordSorter recordSorter;
    private final Map<String, String> initialOffset;

    HttpSourceConnectorConfig(Map<String, ?> originals) {
        super(HttpSourceConnectorConfig.config(), originals);
        Timer timer = (Timer)this.getConfiguredInstance(TIMER, Timer.class);
        this.throttler = new TimerThrottler(timer);
        this.requestFactory = (HttpRequestFactory)this.getConfiguredInstance(REQUEST_FACTORY, HttpRequestFactory.class);
        this.client = (HttpClient)this.getConfiguredInstance(CLIENT, HttpClient.class);
        this.responseParser = (HttpResponseParser)this.getConfiguredInstance(RESPONSE_PARSER, HttpResponseParser.class);
        this.recordSorter = (SourceRecordSorter)this.getConfiguredInstance(RECORD_SORTER, SourceRecordSorter.class);
        this.recordFilterFactory = (SourceRecordFilterFactory)this.getConfiguredInstance(RECORD_FILTER_FACTORY, SourceRecordFilterFactory.class);
        this.initialOffset = ConfigUtils.breakDownMap(this.getString(OFFSET_INITIAL));
    }

    public static ConfigDef config() {
        return new ConfigDef().define(TIMER, ConfigDef.Type.CLASS, AdaptableIntervalTimer.class, ConfigDef.Importance.HIGH, "Poll Timer Class").define(CLIENT, ConfigDef.Type.CLASS, OkHttpClient.class, ConfigDef.Importance.HIGH, "Request Client Class").define(REQUEST_FACTORY, ConfigDef.Type.CLASS, TemplateHttpRequestFactory.class, ConfigDef.Importance.HIGH, "Request Factory Class").define(RESPONSE_PARSER, ConfigDef.Type.CLASS, PolicyHttpResponseParser.class, ConfigDef.Importance.HIGH, "Response Parser Class").define(RECORD_SORTER, ConfigDef.Type.CLASS, OrderDirectionSourceRecordSorter.class, ConfigDef.Importance.LOW, "Record Sorter Class").define(RECORD_FILTER_FACTORY, ConfigDef.Type.CLASS, OffsetRecordFilterFactory.class, ConfigDef.Importance.LOW, "Record Filter Factory Class").define(OFFSET_INITIAL, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, "Starting offset");
    }

    public TimerThrottler getThrottler() {
        return this.throttler;
    }

    public HttpRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public HttpClient getClient() {
        return this.client;
    }

    public HttpResponseParser getResponseParser() {
        return this.responseParser;
    }

    public SourceRecordFilterFactory getRecordFilterFactory() {
        return this.recordFilterFactory;
    }

    public SourceRecordSorter getRecordSorter() {
        return this.recordSorter;
    }

    public Map<String, String> getInitialOffset() {
        return this.initialOffset;
    }
}

