/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.http;

import com.github.castorm.kafka.connect.common.VersionUtils;
import com.github.castorm.kafka.connect.http.HttpSourceConnectorConfig;
import com.github.castorm.kafka.connect.http.ack.ConfirmationWindow;
import com.github.castorm.kafka.connect.http.client.spi.HttpClient;
import com.github.castorm.kafka.connect.http.model.HttpRequest;
import com.github.castorm.kafka.connect.http.model.HttpResponse;
import com.github.castorm.kafka.connect.http.model.Offset;
import com.github.castorm.kafka.connect.http.record.spi.SourceRecordFilterFactory;
import com.github.castorm.kafka.connect.http.record.spi.SourceRecordSorter;
import com.github.castorm.kafka.connect.http.request.spi.HttpRequestFactory;
import com.github.castorm.kafka.connect.http.response.spi.HttpResponseParser;
import com.github.castorm.kafka.connect.timer.TimerThrottler;
import edu.emory.mathcs.backport.java.util.Collections;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.connect.errors.RetriableException;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.source.SourceTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSourceTask
extends SourceTask {
    private static final Logger log = LoggerFactory.getLogger(HttpSourceTask.class);
    private final Function<Map<String, String>, HttpSourceConnectorConfig> configFactory;
    private TimerThrottler throttler;
    private HttpRequestFactory requestFactory;
    private HttpClient requestExecutor;
    private HttpResponseParser responseParser;
    private SourceRecordSorter recordSorter;
    private SourceRecordFilterFactory recordFilterFactory;
    private ConfirmationWindow<Map<String, ?>> confirmationWindow = new ConfirmationWindow(java.util.Collections.emptyList());
    private Offset offset;

    HttpSourceTask(Function<Map<String, String>, HttpSourceConnectorConfig> configFactory) {
        this.configFactory = configFactory;
    }

    public HttpSourceTask() {
        this(HttpSourceConnectorConfig::new);
    }

    public void start(Map<String, String> settings) {
        HttpSourceConnectorConfig config = this.configFactory.apply(settings);
        this.throttler = config.getThrottler();
        this.requestFactory = config.getRequestFactory();
        this.requestExecutor = config.getClient();
        this.responseParser = config.getResponseParser();
        this.recordSorter = config.getRecordSorter();
        this.recordFilterFactory = config.getRecordFilterFactory();
        this.offset = this.loadOffset(config.getInitialOffset());
    }

    private Offset loadOffset(Map<String, String> initialOffset) {
        Map<String, String> restoredOffset = Optional.ofNullable(this.context.offsetStorageReader().offset(java.util.Collections.emptyMap())).orElseGet(Collections::emptyMap);
        return Offset.of(!restoredOffset.isEmpty() ? restoredOffset : initialOffset);
    }

    public List<SourceRecord> poll() throws InterruptedException {
        this.throttler.throttle(this.offset.getTimestamp().orElseGet(Instant::now));
        HttpRequest request = this.requestFactory.createRequest(this.offset);
        HttpResponse response = this.execute(request);
        List<SourceRecord> records = this.responseParser.parse(response);
        List<SourceRecord> unseenRecords = this.recordSorter.sort(records).stream().filter(this.recordFilterFactory.create(this.offset)).collect(Collectors.toList());
        log.info("Request for offset {} yields {}/{} new records", new Object[]{this.offset.toMap(), unseenRecords.size(), records.size()});
        this.confirmationWindow = new ConfirmationWindow(HttpSourceTask.extractOffsets(unseenRecords));
        return unseenRecords;
    }

    private HttpResponse execute(HttpRequest request) {
        try {
            return this.requestExecutor.execute(request);
        }
        catch (IOException e) {
            throw new RetriableException((Throwable)e);
        }
    }

    private static List<Map<String, ?>> extractOffsets(List<SourceRecord> recordsToSend) {
        return recordsToSend.stream().map(SourceRecord::sourceOffset).collect(Collectors.toList());
    }

    public void commitRecord(SourceRecord record, RecordMetadata metadata) {
        this.confirmationWindow.confirm(record.sourceOffset());
    }

    public void commit() {
        this.offset = this.confirmationWindow.getLowWatermarkOffset().map(Offset::of).orElse(this.offset);
        log.debug("Offset set to {}", (Object)this.offset);
    }

    public void stop() {
    }

    public String version() {
        return VersionUtils.getVersion();
    }

    public Offset getOffset() {
        return this.offset;
    }
}

