/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.http.ack;

import com.github.castorm.kafka.connect.common.CollectorsUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfirmationWindow<T> {
    private static final Logger log = LoggerFactory.getLogger(ConfirmationWindow.class);
    private final LinkedHashMap<T, Boolean> confirmedOffsets;

    public ConfirmationWindow(List<T> offsets) {
        this.confirmedOffsets = offsets.stream().collect(CollectorsUtils.toLinkedHashMap(Function.identity(), __ -> false));
    }

    public void confirm(T offset) {
        this.confirmedOffsets.replace(offset, true);
        log.debug("Confirmed offset {}", offset);
    }

    public Optional<T> getLowWatermarkOffset() {
        Object offset = null;
        for (Map.Entry<T, Boolean> offsetEntry : this.confirmedOffsets.entrySet()) {
            Boolean offsetWasConfirmed = offsetEntry.getValue();
            T sourceOffset = offsetEntry.getKey();
            if (offsetWasConfirmed.booleanValue()) {
                offset = sourceOffset;
                continue;
            }
            log.warn("Found unconfirmed offset {}. Will resume polling from previous offset. This might result in a number of duplicated records.", sourceOffset);
            break;
        }
        return Optional.ofNullable(offset);
    }
}

