/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.http.auth;

import com.github.castorm.kafka.connect.http.auth.BasicHttpAuthenticatorConfig;
import com.github.castorm.kafka.connect.http.auth.spi.HttpAuthenticator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import okhttp3.Credentials;
import org.apache.commons.lang.StringUtils;

public class BasicHttpAuthenticator
implements HttpAuthenticator {
    private final Function<Map<String, ?>, BasicHttpAuthenticatorConfig> configFactory;
    Optional<String> header;

    public BasicHttpAuthenticator() {
        this(BasicHttpAuthenticatorConfig::new);
    }

    public BasicHttpAuthenticator(Function<Map<String, ?>, BasicHttpAuthenticatorConfig> configFactory) {
        this.configFactory = configFactory;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        BasicHttpAuthenticatorConfig config = this.configFactory.apply(configs);
        this.header = !StringUtils.isEmpty((String)config.getUser()) || !StringUtils.isEmpty((String)config.getPassword().value()) ? Optional.of(Credentials.basic((String)config.getUser(), (String)config.getPassword().value())) : Optional.empty();
    }

    @Override
    public Optional<String> getAuthorizationHeader() {
        return this.header;
    }
}

