/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.http.auth;

import com.github.castorm.kafka.connect.http.auth.BasicHttpAuthenticator;
import com.github.castorm.kafka.connect.http.auth.NoneHttpAuthenticator;
import com.github.castorm.kafka.connect.http.auth.spi.HttpAuthenticationType;
import com.github.castorm.kafka.connect.http.auth.spi.HttpAuthenticator;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class ConfigurableHttpAuthenticatorConfig
extends AbstractConfig {
    private static final String AUTH_TYPE = "http.auth.type";
    private final HttpAuthenticator authenticator;

    ConfigurableHttpAuthenticatorConfig(Map<String, ?> originals) {
        super(ConfigurableHttpAuthenticatorConfig.config(), originals);
        this.authenticator = this.getAuthenticator(originals);
    }

    private HttpAuthenticator getAuthenticator(Map<String, ?> originals) {
        switch (HttpAuthenticationType.valueOf(this.getString(AUTH_TYPE).toUpperCase())) {
            case BASIC: {
                BasicHttpAuthenticator auth = new BasicHttpAuthenticator();
                auth.configure(originals);
                return auth;
            }
        }
        return new NoneHttpAuthenticator();
    }

    public static ConfigDef config() {
        return new ConfigDef().define(AUTH_TYPE, ConfigDef.Type.STRING, (Object)HttpAuthenticationType.NONE.name(), ConfigDef.Importance.MEDIUM, "Authentication Type");
    }

    public HttpAuthenticator getAuthenticator() {
        return this.authenticator;
    }
}

