/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.http.client.okhttp;

import com.github.castorm.kafka.connect.http.auth.spi.HttpAuthenticator;
import com.github.castorm.kafka.connect.http.client.okhttp.OkHttpClientConfig;
import com.github.castorm.kafka.connect.http.client.spi.HttpClient;
import com.github.castorm.kafka.connect.http.model.HttpRequest;
import com.github.castorm.kafka.connect.http.model.HttpResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpClient
implements HttpClient {
    private static final Logger log = LoggerFactory.getLogger(OkHttpClient.class);
    private okhttp3.OkHttpClient client;
    private HttpAuthenticator authenticator;

    @Override
    public void configure(Map<String, ?> configs) {
        OkHttpClientConfig config = new OkHttpClientConfig(configs);
        this.authenticator = config.getAuthenticator();
        this.client = new OkHttpClient.Builder().connectionPool(new ConnectionPool(config.getMaxIdleConnections().intValue(), config.getKeepAliveDuration().longValue(), TimeUnit.MILLISECONDS)).connectTimeout(config.getConnectionTimeoutMillis().longValue(), TimeUnit.MILLISECONDS).readTimeout(config.getReadTimeoutMillis().longValue(), TimeUnit.MILLISECONDS).retryOnConnectionFailure(true).addInterceptor((Interceptor)OkHttpClient.createLoggingInterceptor()).addInterceptor(chain -> chain.proceed(this.authorize(chain.request()))).authenticator((route, response) -> this.authorize(response.request())).build();
    }

    private Request authorize(Request request) {
        return this.authenticator.getAuthorizationHeader().map(header -> request.newBuilder().header("Authorization", header).build()).orElse(request);
    }

    private static HttpLoggingInterceptor createLoggingInterceptor() {
        if (log.isTraceEnabled()) {
            return new HttpLoggingInterceptor(arg_0 -> ((Logger)log).trace(arg_0)).setLevel(HttpLoggingInterceptor.Level.BODY);
        }
        if (log.isDebugEnabled()) {
            return new HttpLoggingInterceptor(arg_0 -> ((Logger)log).debug(arg_0)).setLevel(HttpLoggingInterceptor.Level.BASIC);
        }
        return new HttpLoggingInterceptor(arg_0 -> ((Logger)log).info(arg_0)).setLevel(HttpLoggingInterceptor.Level.NONE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HttpResponse execute(HttpRequest httpRequest) {
        Request request = OkHttpClient.mapHttpRequest(httpRequest);
        Call call = this.client.newCall(request);
        try (Response response = call.execute();){
            HttpResponse httpResponse = OkHttpClient.mapHttpResponse(response);
            return httpResponse;
        }
    }

    private static Request mapHttpRequest(HttpRequest request) {
        Request.Builder builder = new Request.Builder();
        builder.url(OkHttpClient.mapUrl(request.getUrl(), request.getQueryParams()));
        OkHttpClient.addHeaders(builder, request);
        OkHttpClient.addMethodWithBody(builder, request);
        return builder.build();
    }

    private static HttpUrl mapUrl(String url, Map<String, List<String>> queryParams) {
        HttpUrl httpUrl = HttpUrl.parse((String)url);
        if (httpUrl == null) {
            throw new IllegalStateException(String.format("Illegal url: %s", url));
        }
        HttpUrl.Builder urlBuilder = httpUrl.newBuilder();
        queryParams.forEach((k, list) -> list.forEach(v -> urlBuilder.addEncodedQueryParameter(k, v)));
        return urlBuilder.build();
    }

    private static void addHeaders(Request.Builder builder, HttpRequest request) {
        request.getHeaders().forEach((name, values) -> values.forEach(value -> builder.addHeader(name, value)));
    }

    private static void addMethodWithBody(Request.Builder builder, HttpRequest request) {
        switch (request.getMethod()) {
            case HEAD: {
                builder.head();
                break;
            }
            case PUT: {
                OkHttpClient.mapBody(request).ifPresent(arg_0 -> ((Request.Builder)builder).put(arg_0));
                break;
            }
            case POST: {
                OkHttpClient.mapBody(request).ifPresent(arg_0 -> ((Request.Builder)builder).post(arg_0));
                break;
            }
            case PATCH: {
                OkHttpClient.mapBody(request).ifPresent(arg_0 -> ((Request.Builder)builder).patch(arg_0));
                break;
            }
            default: {
                builder.get();
            }
        }
    }

    private static Optional<RequestBody> mapBody(HttpRequest request) {
        if (request.getBody() != null) {
            return Optional.of(RequestBody.create((byte[])request.getBody()));
        }
        return Optional.empty();
    }

    private static HttpResponse mapHttpResponse(Response response) throws IOException {
        return HttpResponse.builder().code(response.code()).body(response.body() != null ? response.body().bytes() : new byte[]{}).headers(response.headers().toMultimap()).build();
    }
}

