/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.http.client.okhttp;

import com.github.castorm.kafka.connect.http.auth.ConfigurableHttpAuthenticator;
import com.github.castorm.kafka.connect.http.auth.spi.HttpAuthenticator;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class OkHttpClientConfig
extends AbstractConfig {
    private static final String CONNECTION_TIMEOUT_MILLIS = "http.client.connection.timeout.millis";
    private static final String READ_TIMEOUT_MILLIS = "http.client.read.timeout.millis";
    private static final String CONNECTION_KEEP_ALIVE_DURATION_MILLIS = "http.client.ttl.millis";
    private static final String CONNECTION_MAX_IDLE = "http.client.max-idle";
    private static final String AUTHENTICATOR = "http.auth";
    private final Long connectionTimeoutMillis = this.getLong("http.client.connection.timeout.millis");
    private final Long readTimeoutMillis = this.getLong("http.client.read.timeout.millis");
    private final Long keepAliveDuration = this.getLong("http.client.ttl.millis");
    private final Integer maxIdleConnections = this.getInt("http.client.max-idle");
    private final HttpAuthenticator authenticator = (HttpAuthenticator)this.getConfiguredInstance("http.auth", HttpAuthenticator.class);

    OkHttpClientConfig(Map<String, ?> originals) {
        super(OkHttpClientConfig.config(), originals);
    }

    public static ConfigDef config() {
        return new ConfigDef().define(CONNECTION_TIMEOUT_MILLIS, ConfigDef.Type.LONG, (Object)2000, ConfigDef.Importance.HIGH, "Connection Timeout Millis").define(READ_TIMEOUT_MILLIS, ConfigDef.Type.LONG, (Object)2000, ConfigDef.Importance.HIGH, "Read Timeout Millis").define(CONNECTION_KEEP_ALIVE_DURATION_MILLIS, ConfigDef.Type.LONG, (Object)300000, ConfigDef.Importance.HIGH, "Keep Alive Duration Millis").define(CONNECTION_MAX_IDLE, ConfigDef.Type.INT, (Object)1, ConfigDef.Importance.HIGH, "Max Idle Connections").define(AUTHENTICATOR, ConfigDef.Type.CLASS, ConfigurableHttpAuthenticator.class, ConfigDef.Importance.MEDIUM, "Custom Authenticator");
    }

    public Long getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    public Long getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public Long getKeepAliveDuration() {
        return this.keepAliveDuration;
    }

    public Integer getMaxIdleConnections() {
        return this.maxIdleConnections;
    }

    public HttpAuthenticator getAuthenticator() {
        return this.authenticator;
    }
}

