/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.http.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class HttpRequest {
    private final HttpMethod method;
    private final String url;
    private final Map<String, List<String>> queryParams;
    private final Map<String, List<String>> headers;
    private final byte[] body;

    private static HttpMethod $default$method() {
        return HttpMethod.GET;
    }

    private static Map<String, List<String>> $default$queryParams() {
        return Collections.emptyMap();
    }

    private static Map<String, List<String>> $default$headers() {
        return Collections.emptyMap();
    }

    HttpRequest(HttpMethod method, String url, Map<String, List<String>> queryParams, Map<String, List<String>> headers, byte[] body) {
        this.method = method;
        this.url = url;
        this.queryParams = queryParams;
        this.headers = headers;
        this.body = body;
    }

    public static HttpRequestBuilder builder() {
        return new HttpRequestBuilder();
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, List<String>> getQueryParams() {
        return this.queryParams;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public byte[] getBody() {
        return this.body;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRequest)) {
            return false;
        }
        HttpRequest other = (HttpRequest)o;
        HttpMethod this$method = this.getMethod();
        HttpMethod other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        Map<String, List<String>> this$queryParams = this.getQueryParams();
        Map<String, List<String>> other$queryParams = other.getQueryParams();
        if (this$queryParams == null ? other$queryParams != null : !((Object)this$queryParams).equals(other$queryParams)) {
            return false;
        }
        Map<String, List<String>> this$headers = this.getHeaders();
        Map<String, List<String>> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        return Arrays.equals(this.getBody(), other.getBody());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpMethod $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        Map<String, List<String>> $queryParams = this.getQueryParams();
        result = result * 59 + ($queryParams == null ? 43 : ((Object)$queryParams).hashCode());
        Map<String, List<String>> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        result = result * 59 + Arrays.hashCode(this.getBody());
        return result;
    }

    public String toString() {
        return "HttpRequest(method=" + (Object)((Object)this.getMethod()) + ", url=" + this.getUrl() + ", queryParams=" + this.getQueryParams() + ", headers=" + this.getHeaders() + ", body=" + Arrays.toString(this.getBody()) + ")";
    }

    public static class HttpRequestBuilder {
        private boolean method$set;
        private HttpMethod method$value;
        private String url;
        private boolean queryParams$set;
        private Map<String, List<String>> queryParams$value;
        private boolean headers$set;
        private Map<String, List<String>> headers$value;
        private byte[] body;

        HttpRequestBuilder() {
        }

        public HttpRequestBuilder method(HttpMethod method) {
            this.method$value = method;
            this.method$set = true;
            return this;
        }

        public HttpRequestBuilder url(String url) {
            this.url = url;
            return this;
        }

        public HttpRequestBuilder queryParams(Map<String, List<String>> queryParams) {
            this.queryParams$value = queryParams;
            this.queryParams$set = true;
            return this;
        }

        public HttpRequestBuilder headers(Map<String, List<String>> headers) {
            this.headers$value = headers;
            this.headers$set = true;
            return this;
        }

        public HttpRequestBuilder body(byte[] body) {
            this.body = body;
            return this;
        }

        public HttpRequest build() {
            HttpMethod method$value = this.method$value;
            if (!this.method$set) {
                method$value = HttpRequest.$default$method();
            }
            Map queryParams$value = this.queryParams$value;
            if (!this.queryParams$set) {
                queryParams$value = HttpRequest.$default$queryParams();
            }
            Map headers$value = this.headers$value;
            if (!this.headers$set) {
                headers$value = HttpRequest.$default$headers();
            }
            return new HttpRequest(method$value, this.url, queryParams$value, headers$value, this.body);
        }

        public String toString() {
            return "HttpRequest.HttpRequestBuilder(method$value=" + (Object)((Object)this.method$value) + ", url=" + this.url + ", queryParams$value=" + this.queryParams$value + ", headers$value=" + this.headers$value + ", body=" + Arrays.toString(this.body) + ")";
        }
    }

    public static enum HttpMethod {
        GET,
        HEAD,
        POST,
        PUT,
        PATCH;

    }
}

