/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.http.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class HttpResponse {
    private final Integer code;
    private final byte[] body;
    private final Map<String, List<String>> headers;

    private static Map<String, List<String>> $default$headers() {
        return Collections.emptyMap();
    }

    HttpResponse(Integer code, byte[] body, Map<String, List<String>> headers) {
        this.code = code;
        this.body = body;
        this.headers = headers;
    }

    public static HttpResponseBuilder builder() {
        return new HttpResponseBuilder();
    }

    public Integer getCode() {
        return this.code;
    }

    public byte[] getBody() {
        return this.body;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpResponse)) {
            return false;
        }
        HttpResponse other = (HttpResponse)o;
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        if (!Arrays.equals(this.getBody(), other.getBody())) {
            return false;
        }
        Map<String, List<String>> this$headers = this.getHeaders();
        Map<String, List<String>> other$headers = other.getHeaders();
        return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        result = result * 59 + Arrays.hashCode(this.getBody());
        Map<String, List<String>> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        return result;
    }

    public String toString() {
        return "HttpResponse(code=" + this.getCode() + ", body=" + Arrays.toString(this.getBody()) + ", headers=" + this.getHeaders() + ")";
    }

    public HttpResponse withCode(Integer code) {
        return this.code == code ? this : new HttpResponse(code, this.body, this.headers);
    }

    public HttpResponse withBody(byte[] body) {
        return this.body == body ? this : new HttpResponse(this.code, body, this.headers);
    }

    public HttpResponse withHeaders(Map<String, List<String>> headers) {
        return this.headers == headers ? this : new HttpResponse(this.code, this.body, headers);
    }

    public static class HttpResponseBuilder {
        private Integer code;
        private byte[] body;
        private boolean headers$set;
        private Map<String, List<String>> headers$value;

        HttpResponseBuilder() {
        }

        public HttpResponseBuilder code(Integer code) {
            this.code = code;
            return this;
        }

        public HttpResponseBuilder body(byte[] body) {
            this.body = body;
            return this;
        }

        public HttpResponseBuilder headers(Map<String, List<String>> headers) {
            this.headers$value = headers;
            this.headers$set = true;
            return this;
        }

        public HttpResponse build() {
            Map headers$value = this.headers$value;
            if (!this.headers$set) {
                headers$value = HttpResponse.$default$headers();
            }
            return new HttpResponse(this.code, this.body, headers$value);
        }

        public String toString() {
            return "HttpResponse.HttpResponseBuilder(code=" + this.code + ", body=" + Arrays.toString(this.body) + ", headers$value=" + this.headers$value + ")";
        }
    }
}

