/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.http.model;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class Offset {
    private static final String KEY_KEY = "key";
    private static final String TIMESTAMP_KEY = "timestamp";
    private final Map<String, ?> properties;

    private Offset(Map<String, ?> properties) {
        this.properties = properties;
    }

    public static Offset of(Map<String, ?> properties) {
        return new Offset(properties);
    }

    public static Offset of(Map<String, ?> properties, String key) {
        HashMap props = new HashMap(properties);
        props.put(KEY_KEY, key);
        return new Offset(props);
    }

    public static Offset of(Map<String, ?> properties, String key, Instant timestamp) {
        HashMap props = new HashMap(properties);
        props.put(KEY_KEY, key);
        props.put(TIMESTAMP_KEY, timestamp.toString());
        return new Offset(props);
    }

    public Map<String, ?> toMap() {
        return this.properties;
    }

    public Optional<String> getKey() {
        return Optional.ofNullable((String)this.properties.get(KEY_KEY));
    }

    public Optional<Instant> getTimestamp() {
        return Optional.ofNullable((String)this.properties.get(TIMESTAMP_KEY)).map(Instant::parse);
    }

    public String toString() {
        return "Offset(properties=" + this.properties + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Offset)) {
            return false;
        }
        Offset other = (Offset)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, ?> this$properties = this.properties;
        Map<String, ?> other$properties = other.properties;
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Offset;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, ?> $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }
}

