/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.http.record;

import com.github.castorm.kafka.connect.http.model.Offset;
import com.github.castorm.kafka.connect.http.record.OffsetTimestampRecordFilterFactory;
import com.github.castorm.kafka.connect.http.record.spi.SourceRecordFilterFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.apache.kafka.connect.source.SourceRecord;

public class OffsetRecordFilterFactory
implements SourceRecordFilterFactory {
    private final SourceRecordFilterFactory delegate;

    public OffsetRecordFilterFactory() {
        this(new OffsetTimestampRecordFilterFactory());
    }

    @Override
    public Predicate<SourceRecord> create(Offset offset) {
        AtomicBoolean lastSeenReached = new AtomicBoolean(false);
        return this.delegate.create(offset).or(record -> {
            boolean result = lastSeenReached.get();
            if (!result && Offset.of(record.sourceOffset()).equals(offset)) {
                lastSeenReached.set(true);
            }
            return result;
        });
    }

    public OffsetRecordFilterFactory(SourceRecordFilterFactory delegate) {
        this.delegate = delegate;
    }
}

