/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.http.record;

import com.github.castorm.kafka.connect.http.record.OrderDirectionSourceRecordSorterConfig;
import com.github.castorm.kafka.connect.http.record.spi.SourceRecordSorter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.connect.source.SourceRecord;

public class OrderDirectionSourceRecordSorter
implements SourceRecordSorter {
    private final Function<Map<String, ?>, OrderDirectionSourceRecordSorterConfig> configFactory;
    private OrderDirection orderDirection;

    public OrderDirectionSourceRecordSorter() {
        this(OrderDirectionSourceRecordSorterConfig::new);
    }

    @Override
    public void configure(Map<String, ?> settings) {
        this.orderDirection = this.configFactory.apply(settings).getOrderDirection();
    }

    @Override
    public List<SourceRecord> sort(List<SourceRecord> records) {
        return OrderDirectionSourceRecordSorter.sortWithDirection(records, this.orderDirection);
    }

    private static List<SourceRecord> sortWithDirection(List<SourceRecord> records, OrderDirection direction) {
        switch (direction) {
            case DESC: {
                ArrayList<SourceRecord> reversed = new ArrayList<SourceRecord>(records);
                Collections.reverse(reversed);
                return reversed;
            }
            case ASC: {
                return records;
            }
        }
        return OrderDirectionSourceRecordSorter.sortWithDirection(records, OrderDirectionSourceRecordSorter.getImplicitDirection(records));
    }

    private static OrderDirection getImplicitDirection(List<SourceRecord> records) {
        if (records.size() >= 2) {
            Long first = records.get(0).timestamp();
            Long last = records.get(records.size() - 1).timestamp();
            return first <= last ? OrderDirection.ASC : OrderDirection.DESC;
        }
        return OrderDirection.ASC;
    }

    public OrderDirectionSourceRecordSorter(Function<Map<String, ?>, OrderDirectionSourceRecordSorterConfig> configFactory) {
        this.configFactory = configFactory;
    }

    public static enum OrderDirection {
        ASC,
        DESC,
        IMPLICIT;

    }
}

