/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.http.record;

import com.github.castorm.kafka.connect.http.model.Offset;
import com.github.castorm.kafka.connect.http.record.SourceRecordMapperConfig;
import com.github.castorm.kafka.connect.http.record.model.KvRecord;
import com.github.castorm.kafka.connect.http.record.spi.KvSourceRecordMapper;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;

public class SchemedKvSourceRecordMapper
implements KvSourceRecordMapper {
    private static final String KEY_FIELD_NAME = "key";
    private static final String VALUE_FIELD_NAME = "value";
    private static final String TIMESTAMP_FIELD_NAME = "timestamp";
    private static Map<String, ?> sourcePartition = Collections.emptyMap();
    private final Function<Map<String, ?>, SourceRecordMapperConfig> configFactory;
    private SourceRecordMapperConfig config;
    private Schema keySchema;
    private Schema valueSchema;

    public SchemedKvSourceRecordMapper() {
        this(SourceRecordMapperConfig::new);
    }

    @Override
    public void configure(Map<String, ?> settings) {
        this.config = this.configFactory.apply(settings);
        this.keySchema = SchemaBuilder.struct().name("com.github.castorm.kafka.connect.http.Key").doc("Message Key").field(KEY_FIELD_NAME, SchemaBuilder.string().optional().doc("HTTP Record Key").build()).build();
        this.valueSchema = SchemaBuilder.struct().name("com.github.castorm.kafka.connect.http.Value").doc("Message Value").field(VALUE_FIELD_NAME, SchemaBuilder.string().doc("HTTP Record Value").build()).field(KEY_FIELD_NAME, SchemaBuilder.string().optional().doc("HTTP Record Key").build()).field(TIMESTAMP_FIELD_NAME, SchemaBuilder.int64().optional().doc("HTTP Record Timestamp").build()).build();
    }

    @Override
    public SourceRecord map(KvRecord record) {
        Offset offset = record.getOffset();
        Long timestamp = offset.getTimestamp().map(Instant::toEpochMilli).orElseGet(System::currentTimeMillis);
        Struct key = this.keyStruct(record.getKey());
        Struct value = this.valueStruct(record.getKey(), record.getValue(), timestamp);
        return new SourceRecord(sourcePartition, offset.toMap(), this.config.getTopic(), null, key.schema(), (Object)key, value.schema(), (Object)value, timestamp);
    }

    private Struct keyStruct(String key) {
        return new Struct(this.keySchema).put(KEY_FIELD_NAME, (Object)key);
    }

    private Struct valueStruct(String key, String value, Long timestamp) {
        return new Struct(this.valueSchema).put(KEY_FIELD_NAME, (Object)key).put(VALUE_FIELD_NAME, (Object)value).put(TIMESTAMP_FIELD_NAME, (Object)timestamp);
    }

    public SchemedKvSourceRecordMapper(Function<Map<String, ?>, SourceRecordMapperConfig> configFactory) {
        this.configFactory = configFactory;
    }
}

