/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.http.record.model;

import com.github.castorm.kafka.connect.http.model.Offset;

public final class KvRecord {
    private final String key;
    private final String value;
    private final Offset offset;

    KvRecord(String key, String value, Offset offset) {
        this.key = key;
        this.value = value;
        this.offset = offset;
    }

    public static KvRecordBuilder builder() {
        return new KvRecordBuilder();
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public Offset getOffset() {
        return this.offset;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KvRecord)) {
            return false;
        }
        KvRecord other = (KvRecord)o;
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        Offset this$offset = this.getOffset();
        Offset other$offset = other.getOffset();
        return !(this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        Offset $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        return result;
    }

    public String toString() {
        return "KvRecord(key=" + this.getKey() + ", value=" + this.getValue() + ", offset=" + this.getOffset() + ")";
    }

    public KvRecord withKey(String key) {
        return this.key == key ? this : new KvRecord(key, this.value, this.offset);
    }

    public KvRecord withValue(String value) {
        return this.value == value ? this : new KvRecord(this.key, value, this.offset);
    }

    public KvRecord withOffset(Offset offset) {
        return this.offset == offset ? this : new KvRecord(this.key, this.value, offset);
    }

    public static class KvRecordBuilder {
        private String key;
        private String value;
        private Offset offset;

        KvRecordBuilder() {
        }

        public KvRecordBuilder key(String key) {
            this.key = key;
            return this;
        }

        public KvRecordBuilder value(String value) {
            this.value = value;
            return this;
        }

        public KvRecordBuilder offset(Offset offset) {
            this.offset = offset;
            return this;
        }

        public KvRecord build() {
            return new KvRecord(this.key, this.value, this.offset);
        }

        public String toString() {
            return "KvRecord.KvRecordBuilder(key=" + this.key + ", value=" + this.value + ", offset=" + this.offset + ")";
        }
    }
}

