/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.http.request.template;

import com.github.castorm.kafka.connect.common.ConfigUtils;
import com.github.castorm.kafka.connect.http.model.HttpRequest;
import com.github.castorm.kafka.connect.http.model.Offset;
import com.github.castorm.kafka.connect.http.request.spi.HttpRequestFactory;
import com.github.castorm.kafka.connect.http.request.template.TemplateHttpRequestFactoryConfig;
import com.github.castorm.kafka.connect.http.request.template.spi.Template;
import com.github.castorm.kafka.connect.http.request.template.spi.TemplateFactory;
import java.util.Map;

public class TemplateHttpRequestFactory
implements HttpRequestFactory {
    private String method;
    private Template urlTpl;
    private Template headersTpl;
    private Template queryParamsTpl;
    private Template bodyTpl;

    @Override
    public void configure(Map<String, ?> configs) {
        TemplateHttpRequestFactoryConfig config = new TemplateHttpRequestFactoryConfig(configs);
        TemplateFactory templateFactory = config.getTemplateFactory();
        this.method = config.getMethod();
        this.urlTpl = templateFactory.create(config.getUrl());
        this.headersTpl = templateFactory.create(config.getHeaders());
        this.queryParamsTpl = templateFactory.create(config.getQueryParams());
        this.bodyTpl = templateFactory.create(config.getBody());
    }

    @Override
    public HttpRequest createRequest(Offset offset) {
        return HttpRequest.builder().method(HttpRequest.HttpMethod.valueOf(this.method)).url(this.urlTpl.apply(offset)).headers(ConfigUtils.breakDownHeaders(this.headersTpl.apply(offset))).queryParams(ConfigUtils.breakDownQueryParams(this.queryParamsTpl.apply(offset))).body(this.bodyTpl.apply(offset).getBytes()).build();
    }
}

