/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.http.request.template;

import com.github.castorm.kafka.connect.http.request.template.freemarker.BackwardsCompatibleFreeMarkerTemplateFactory;
import com.github.castorm.kafka.connect.http.request.template.spi.TemplateFactory;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class TemplateHttpRequestFactoryConfig
extends AbstractConfig {
    private static final String URL = "http.request.url";
    private static final String METHOD = "http.request.method";
    private static final String HEADERS = "http.request.headers";
    private static final String QUERY_PARAMS = "http.request.params";
    private static final String BODY = "http.request.body";
    private static final String TEMPLATE_FACTORY = "http.request.template.factory";
    private final String url = this.getString("http.request.url");
    private final String method = this.getString("http.request.method");
    private final String headers = this.getString("http.request.headers");
    private final String queryParams = this.getString("http.request.params");
    private final String body = this.getString("http.request.body");
    private final TemplateFactory templateFactory = (TemplateFactory)this.getConfiguredInstance("http.request.template.factory", TemplateFactory.class);

    TemplateHttpRequestFactoryConfig(Map<String, ?> originals) {
        super(TemplateHttpRequestFactoryConfig.config(), originals);
    }

    public static ConfigDef config() {
        return new ConfigDef().define(URL, ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "HTTP URL Template").define(METHOD, ConfigDef.Type.STRING, (Object)"GET", ConfigDef.Importance.HIGH, "HTTP Method Template").define(HEADERS, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, "HTTP Headers Template").define(QUERY_PARAMS, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, "HTTP Query Params Template").define(BODY, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "HTTP Body Template").define(TEMPLATE_FACTORY, ConfigDef.Type.CLASS, BackwardsCompatibleFreeMarkerTemplateFactory.class, ConfigDef.Importance.LOW, "Template Factory Class");
    }

    public String getUrl() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public String getHeaders() {
        return this.headers;
    }

    public String getQueryParams() {
        return this.queryParams;
    }

    public String getBody() {
        return this.body;
    }

    public TemplateFactory getTemplateFactory() {
        return this.templateFactory;
    }
}

