/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.http.request.template.freemarker;

import com.github.castorm.kafka.connect.http.request.template.spi.Template;
import com.github.castorm.kafka.connect.http.request.template.spi.TemplateFactory;
import freemarker.template.Configuration;
import freemarker.template.Version;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.UUID;

public class FreeMarkerTemplateFactory
implements TemplateFactory {
    private final Configuration configuration = new Configuration(new Version(2, 3, 30)){
        {
            this.setNumberFormat("computer");
        }
    };

    @Override
    public Template create(String template) {
        return offset -> this.apply(this.createTemplate(template), new TemplateModel(offset.toMap()));
    }

    private freemarker.template.Template createTemplate(String template) {
        return new freemarker.template.Template(UUID.randomUUID().toString(), (Reader)new StringReader(template), this.configuration);
    }

    private String apply(freemarker.template.Template template, TemplateModel model) {
        StringWriter writer = new StringWriter();
        template.process((Object)model, (Writer)writer);
        return ((Object)writer).toString();
    }

    public static final class TemplateModel {
        private final Map<String, ?> offset;

        public TemplateModel(Map<String, ?> offset) {
            this.offset = offset;
        }

        public Map<String, ?> getOffset() {
            return this.offset;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TemplateModel)) {
                return false;
            }
            TemplateModel other = (TemplateModel)o;
            Map<String, ?> this$offset = this.getOffset();
            Map<String, ?> other$offset = other.getOffset();
            return !(this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, ?> $offset = this.getOffset();
            result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
            return result;
        }

        public String toString() {
            return "FreeMarkerTemplateFactory.TemplateModel(offset=" + this.getOffset() + ")";
        }
    }
}

