/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.http.response;

import com.github.castorm.kafka.connect.http.model.HttpResponse;
import com.github.castorm.kafka.connect.http.record.spi.KvSourceRecordMapper;
import com.github.castorm.kafka.connect.http.response.KvHttpResponseParserConfig;
import com.github.castorm.kafka.connect.http.response.spi.HttpResponseParser;
import com.github.castorm.kafka.connect.http.response.spi.KvRecordHttpResponseParser;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.connect.source.SourceRecord;

public class KvHttpResponseParser
implements HttpResponseParser {
    private final Function<Map<String, ?>, KvHttpResponseParserConfig> configFactory;
    private KvRecordHttpResponseParser recordParser;
    private KvSourceRecordMapper recordMapper;

    public KvHttpResponseParser() {
        this(KvHttpResponseParserConfig::new);
    }

    @Override
    public void configure(Map<String, ?> configs) {
        KvHttpResponseParserConfig config = this.configFactory.apply(configs);
        this.recordParser = config.getRecordParser();
        this.recordMapper = config.getRecordMapper();
    }

    @Override
    public List<SourceRecord> parse(HttpResponse response) {
        return this.recordParser.parse(response).stream().map(this.recordMapper::map).collect(Collectors.toList());
    }

    public KvHttpResponseParser(Function<Map<String, ?>, KvHttpResponseParserConfig> configFactory) {
        this.configFactory = configFactory;
    }
}

