/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.http.response;

import com.github.castorm.kafka.connect.http.model.HttpResponse;
import com.github.castorm.kafka.connect.http.response.PolicyHttpResponseParserConfig;
import com.github.castorm.kafka.connect.http.response.spi.HttpResponseParser;
import com.github.castorm.kafka.connect.http.response.spi.HttpResponsePolicy;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.kafka.connect.source.SourceRecord;

public class PolicyHttpResponseParser
implements HttpResponseParser {
    private final Function<Map<String, ?>, PolicyHttpResponseParserConfig> configFactory;
    private HttpResponseParser delegate;
    private HttpResponsePolicy policy;

    public PolicyHttpResponseParser() {
        this(PolicyHttpResponseParserConfig::new);
    }

    @Override
    public void configure(Map<String, ?> settings) {
        PolicyHttpResponseParserConfig config = this.configFactory.apply(settings);
        this.delegate = config.getDelegateParser();
        this.policy = config.getPolicy();
    }

    @Override
    public List<SourceRecord> parse(HttpResponse response) {
        switch (this.policy.resolve(response)) {
            case PROCESS: {
                return this.delegate.parse(response);
            }
            case SKIP: {
                return Collections.emptyList();
            }
        }
        throw new IllegalStateException(String.format("Policy failed for response code: %s, body: %s", response.getCode(), Optional.ofNullable(response.getBody()).map(String::new).orElse("")));
    }

    public PolicyHttpResponseParser(Function<Map<String, ?>, PolicyHttpResponseParserConfig> configFactory) {
        this.configFactory = configFactory;
    }
}

