/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.http.response;

import com.github.castorm.kafka.connect.http.model.HttpResponse;
import com.github.castorm.kafka.connect.http.response.StatusCodeHttpResponsePolicyConfig;
import com.github.castorm.kafka.connect.http.response.spi.HttpResponsePolicy;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusCodeHttpResponsePolicy
implements HttpResponsePolicy {
    private static final Logger log = LoggerFactory.getLogger(StatusCodeHttpResponsePolicy.class);
    private final Function<Map<String, ?>, StatusCodeHttpResponsePolicyConfig> configFactory;
    private Set<Integer> processCodes;
    private Set<Integer> skipCodes;

    public StatusCodeHttpResponsePolicy() {
        this(StatusCodeHttpResponsePolicyConfig::new);
    }

    @Override
    public void configure(Map<String, ?> settings) {
        StatusCodeHttpResponsePolicyConfig config = this.configFactory.apply(settings);
        this.processCodes = config.getProcessCodes();
        this.skipCodes = config.getSkipCodes();
    }

    @Override
    public HttpResponsePolicy.HttpResponseOutcome resolve(HttpResponse response) {
        if (this.processCodes.contains(response.getCode())) {
            return HttpResponsePolicy.HttpResponseOutcome.PROCESS;
        }
        if (this.skipCodes.contains(response.getCode())) {
            log.warn("Unexpected HttpResponse status code: {}, continuing with no records", (Object)response.getCode());
            return HttpResponsePolicy.HttpResponseOutcome.SKIP;
        }
        return HttpResponsePolicy.HttpResponseOutcome.FAIL;
    }

    public StatusCodeHttpResponsePolicy(Function<Map<String, ?>, StatusCodeHttpResponsePolicyConfig> configFactory) {
        this.configFactory = configFactory;
    }
}

