/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.http.response;

import com.github.castorm.kafka.connect.common.ConfigUtils;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class StatusCodeHttpResponsePolicyConfig
extends AbstractConfig {
    private static final String PROCESS_CODES = "http.response.policy.codes.process";
    private static final String SKIP_CODES = "http.response.policy.codes.skip";
    private final Set<Integer> processCodes = ConfigUtils.parseIntegerRangedList(this.getString("http.response.policy.codes.process"));
    private final Set<Integer> skipCodes = ConfigUtils.parseIntegerRangedList(this.getString("http.response.policy.codes.skip"));

    public StatusCodeHttpResponsePolicyConfig(Map<String, ?> originals) {
        super(StatusCodeHttpResponsePolicyConfig.config(), originals);
    }

    public static ConfigDef config() {
        return new ConfigDef().define(PROCESS_CODES, ConfigDef.Type.STRING, (Object)"200..299", ConfigDef.Importance.HIGH, "Process Codes").define(SKIP_CODES, ConfigDef.Type.STRING, (Object)"300..399", ConfigDef.Importance.HIGH, "Skip Codes");
    }

    public Set<Integer> getProcessCodes() {
        return this.processCodes;
    }

    public Set<Integer> getSkipCodes() {
        return this.skipCodes;
    }
}

