/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.http.response.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.castorm.kafka.connect.http.model.HttpResponse;
import com.github.castorm.kafka.connect.http.model.Offset;
import com.github.castorm.kafka.connect.http.record.model.KvRecord;
import com.github.castorm.kafka.connect.http.response.jackson.JacksonKvRecordHttpResponseParserConfig;
import com.github.castorm.kafka.connect.http.response.jackson.JacksonRecordParser;
import com.github.castorm.kafka.connect.http.response.spi.KvRecordHttpResponseParser;
import com.github.castorm.kafka.connect.http.response.timestamp.spi.TimestampParser;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;

public class JacksonKvRecordHttpResponseParser
implements KvRecordHttpResponseParser {
    private final Function<Map<String, ?>, JacksonKvRecordHttpResponseParserConfig> configFactory;
    private JacksonRecordParser recordParser;
    private TimestampParser timestampParser;

    public JacksonKvRecordHttpResponseParser() {
        this(JacksonKvRecordHttpResponseParserConfig::new);
    }

    @Override
    public void configure(Map<String, ?> configs) {
        JacksonKvRecordHttpResponseParserConfig config = this.configFactory.apply(configs);
        this.recordParser = config.getRecordParser();
        this.timestampParser = config.getTimestampParser();
    }

    @Override
    public List<KvRecord> parse(HttpResponse response) {
        return this.recordParser.getRecords(response.getBody()).map(this::map).collect(Collectors.toList());
    }

    private KvRecord map(JsonNode node) {
        Map<String, Object> offsets = this.recordParser.getOffsets(node);
        String key = this.recordParser.getKey(node).map(Optional::of).orElseGet(() -> Optional.ofNullable(offsets.get("key")).map(String.class::cast)).orElseGet(() -> this.generateConsistentKey(node));
        Optional<Instant> timestamp = this.recordParser.getTimestamp(node).map(Optional::of).orElseGet(() -> Optional.ofNullable(offsets.get("timestamp")).map(String.class::cast)).map(this.timestampParser::parse);
        Offset offset = timestamp.map((? super T ts) -> Offset.of(offsets, key, ts)).orElseGet(() -> Offset.of(offsets, key));
        return KvRecord.builder().key(key).value(this.recordParser.getValue(node)).offset(offset).build();
    }

    private String generateConsistentKey(JsonNode node) {
        return UUID.nameUUIDFromBytes(node.toString().getBytes()).toString();
    }

    public JacksonKvRecordHttpResponseParser(Function<Map<String, ?>, JacksonKvRecordHttpResponseParserConfig> configFactory) {
        this.configFactory = configFactory;
    }
}

