/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.http.response.jackson;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

class JacksonPropertyResolver {
    private static final JsonPointer JSON_ROOT = JsonPointer.compile((String)"/");

    JacksonPropertyResolver() {
    }

    JsonNode getObjectAt(JsonNode node, JsonPointer pointer) {
        return JacksonPropertyResolver.getRequiredAt(node, pointer);
    }

    Stream<JsonNode> getArrayAt(JsonNode node, JsonPointer pointer) {
        JsonNode array = JacksonPropertyResolver.getRequiredAt(node, pointer);
        return array.isArray() ? StreamSupport.stream(array.spliterator(), false) : Stream.of(array);
    }

    private static JsonNode getRequiredAt(JsonNode body, JsonPointer recordsPointer) {
        return JSON_ROOT.equals((Object)recordsPointer) ? body : body.requiredAt(recordsPointer);
    }
}

