/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.http.response.jackson;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.castorm.kafka.connect.http.response.jackson.JacksonPropertyResolver;
import com.github.castorm.kafka.connect.http.response.jackson.JacksonRecordParserConfig;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.Configurable;

public class JacksonRecordParser
implements Configurable {
    private final Function<Map<String, ?>, JacksonRecordParserConfig> configFactory;
    private final ObjectMapper objectMapper;
    private final JacksonPropertyResolver propertyResolver;
    private JsonPointer recordsPointer;
    private List<JsonPointer> keyPointer;
    private Optional<JsonPointer> timestampPointer;
    private Map<String, JsonPointer> offsetPointers;
    private JsonPointer valuePointer;

    public JacksonRecordParser() {
        this(JacksonRecordParserConfig::new, new ObjectMapper(), new JacksonPropertyResolver());
    }

    public void configure(Map<String, ?> settings) {
        JacksonRecordParserConfig config = this.configFactory.apply(settings);
        this.recordsPointer = config.getRecordsPointer();
        this.keyPointer = config.getKeyPointer();
        this.valuePointer = config.getValuePointer();
        this.offsetPointers = config.getOffsetPointers();
        this.timestampPointer = config.getTimestampPointer();
    }

    Stream<JsonNode> getRecords(byte[] body) {
        return this.propertyResolver.getArrayAt(this.deserialize(body), this.recordsPointer);
    }

    @Deprecated
    Optional<String> getKey(JsonNode node) {
        String key = this.keyPointer.stream().map(pointer -> this.propertyResolver.getObjectAt(node, (JsonPointer)pointer).asText()).filter(it -> !it.isEmpty()).collect(Collectors.joining("+"));
        return key.isEmpty() ? Optional.empty() : Optional.of(key);
    }

    @Deprecated
    Optional<String> getTimestamp(JsonNode node) {
        return this.timestampPointer.map(pointer -> this.propertyResolver.getObjectAt(node, (JsonPointer)pointer).asText());
    }

    Map<String, Object> getOffsets(JsonNode node) {
        return this.offsetPointers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.propertyResolver.getObjectAt(node, (JsonPointer)entry.getValue()).asText()));
    }

    String getValue(JsonNode node) {
        JsonNode value = this.propertyResolver.getObjectAt(node, this.valuePointer);
        return value.isObject() ? this.serialize(value) : value.asText();
    }

    private JsonNode deserialize(byte[] body) {
        return this.objectMapper.readTree(body);
    }

    private String serialize(JsonNode node) {
        return this.objectMapper.writeValueAsString((Object)node);
    }

    public JacksonRecordParser(Function<Map<String, ?>, JacksonRecordParserConfig> configFactory, ObjectMapper objectMapper, JacksonPropertyResolver propertyResolver) {
        this.configFactory = configFactory;
        this.objectMapper = objectMapper;
        this.propertyResolver = propertyResolver;
    }
}

