/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.http.response.jackson;

import com.fasterxml.jackson.core.JsonPointer;
import com.github.castorm.kafka.connect.common.ConfigUtils;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class JacksonRecordParserConfig
extends AbstractConfig {
    private static final String LIST_POINTER = "http.response.list.pointer";
    private static final String ITEM_POINTER = "http.response.record.pointer";
    private static final String ITEM_KEY_POINTER = "http.response.record.key.pointer";
    private static final String ITEM_TIMESTAMP_POINTER = "http.response.record.timestamp.pointer";
    private static final String ITEM_OFFSET_VALUE_POINTER = "http.response.record.offset.pointer";
    private final JsonPointer recordsPointer = JsonPointer.compile((String)this.getString("http.response.list.pointer"));
    private final List<JsonPointer> keyPointer = ConfigUtils.breakDownList(Optional.ofNullable(this.getString("http.response.record.key.pointer")).orElse("")).stream().map(JsonPointer::compile).collect(Collectors.toList());
    private final JsonPointer valuePointer = JsonPointer.compile((String)this.getString("http.response.record.pointer"));
    private final Optional<JsonPointer> timestampPointer = Optional.ofNullable(this.getString("http.response.record.timestamp.pointer")).map(JsonPointer::compile);
    private final Map<String, JsonPointer> offsetPointers = ConfigUtils.breakDownMap(this.getString("http.response.record.offset.pointer")).entrySet().stream().map(entry -> new AbstractMap.SimpleEntry(entry.getKey(), JsonPointer.compile((String)((String)entry.getValue())))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));

    JacksonRecordParserConfig(Map<String, ?> originals) {
        super(JacksonRecordParserConfig.config(), originals);
    }

    public static ConfigDef config() {
        return new ConfigDef().define(LIST_POINTER, ConfigDef.Type.STRING, (Object)"/", ConfigDef.Importance.HIGH, "Item List JsonPointer").define(ITEM_POINTER, ConfigDef.Type.STRING, (Object)"/", ConfigDef.Importance.HIGH, "Item JsonPointer").define(ITEM_KEY_POINTER, ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "Item Key JsonPointers").define(ITEM_TIMESTAMP_POINTER, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "Item Timestamp JsonPointer").define(ITEM_OFFSET_VALUE_POINTER, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, "Item Offset JsonPointers");
    }

    public JsonPointer getRecordsPointer() {
        return this.recordsPointer;
    }

    public List<JsonPointer> getKeyPointer() {
        return this.keyPointer;
    }

    public JsonPointer getValuePointer() {
        return this.valuePointer;
    }

    public Optional<JsonPointer> getTimestampPointer() {
        return this.timestampPointer;
    }

    public Map<String, JsonPointer> getOffsetPointers() {
        return this.offsetPointers;
    }
}

