/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.http.response.timestamp;

import com.github.castorm.kafka.connect.http.response.timestamp.DateTimeFormatterTimestampParserConfig;
import com.github.castorm.kafka.connect.http.response.timestamp.spi.TimestampParser;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.function.Function;

public class DateTimeFormatterTimestampParser
implements TimestampParser {
    private final Function<Map<String, ?>, DateTimeFormatterTimestampParserConfig> configFactory;
    private DateTimeFormatter timestampFormatter;

    public DateTimeFormatterTimestampParser() {
        this(DateTimeFormatterTimestampParserConfig::new);
    }

    @Override
    public void configure(Map<String, ?> settings) {
        this.timestampFormatter = this.configFactory.apply(settings).getRecordTimestampFormatter();
    }

    @Override
    public Instant parse(String timestamp) {
        return OffsetDateTime.parse(timestamp, this.timestampFormatter).toInstant();
    }

    public DateTimeFormatterTimestampParser(Function<Map<String, ?>, DateTimeFormatterTimestampParserConfig> configFactory) {
        this.configFactory = configFactory;
    }
}

