/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.http.response.timestamp;

import com.github.castorm.kafka.connect.http.response.timestamp.EpochMillisOrDelegateTimestampParserConfig;
import com.github.castorm.kafka.connect.http.response.timestamp.spi.TimestampParser;
import java.time.Instant;
import java.util.Map;
import java.util.function.Function;

public class EpochMillisOrDelegateTimestampParser
implements TimestampParser {
    private final Function<Map<String, ?>, EpochMillisOrDelegateTimestampParserConfig> configFactory;
    private TimestampParser delegate;

    public EpochMillisOrDelegateTimestampParser() {
        this(EpochMillisOrDelegateTimestampParserConfig::new);
    }

    @Override
    public void configure(Map<String, ?> settings) {
        EpochMillisOrDelegateTimestampParserConfig config = this.configFactory.apply(settings);
        this.delegate = config.getDelegateParser();
    }

    @Override
    public Instant parse(String timestamp) {
        try {
            return Instant.ofEpochMilli(Long.parseLong(timestamp));
        }
        catch (NumberFormatException e) {
            return this.delegate.parse(timestamp);
        }
    }

    public EpochMillisOrDelegateTimestampParser(Function<Map<String, ?>, EpochMillisOrDelegateTimestampParserConfig> configFactory) {
        this.configFactory = configFactory;
    }
}

