/*
 * Decompiled with CFR 0.152.
 */
package com.github.castorm.kafka.connect.http.response.timestamp;

import com.github.castorm.kafka.connect.http.response.timestamp.NattyTimestampParserConfig;
import com.github.castorm.kafka.connect.http.response.timestamp.spi.TimestampParser;
import com.joestelmach.natty.Parser;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class NattyTimestampParser
implements TimestampParser {
    private final Parser parser = new Parser();
    private final Function<Map<String, ?>, NattyTimestampParserConfig> configFactory;
    private Optional<ZoneId> zoneId;

    public NattyTimestampParser() {
        this(NattyTimestampParserConfig::new);
    }

    @Override
    public void configure(Map<String, ?> settings) {
        this.zoneId = this.configFactory.apply(settings).getTimestampZoneId();
    }

    @Override
    public Instant parse(String timestamp) {
        return Optional.ofNullable(this.parser.parse(timestamp)).orElse(Collections.emptyList()).stream().findFirst().flatMap(it -> it.getDates().stream().findFirst()).map(this::mapWithZoneId).orElseThrow(() -> new IllegalStateException("Couldn't parse timestamp " + timestamp));
    }

    private Instant mapWithZoneId(Date it) {
        return this.zoneId.map(zoneId -> it.toInstant().atZone(ZoneId.systemDefault()).withZoneSameLocal((ZoneId)zoneId).toInstant()).orElseGet(it::toInstant);
    }

    public NattyTimestampParser(Function<Map<String, ?>, NattyTimestampParserConfig> configFactory) {
        this.configFactory = configFactory;
    }
}

